"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchAlertData = void 0;
var _react = require("react");
var _constants = require("../../data_view_manager/constants");
var _containers = require("../../sourcerer/containers");
var _use_query = require("../../detections/containers/detection_engine/alerts/use_query");
var _constants2 = require("../../detections/containers/detection_engine/alerts/constants");
var _alerts = require("../../common/utils/alerts");
var _use_experimental_features = require("../../common/hooks/use_experimental_features");
var _use_selected_patterns = require("../../data_view_manager/hooks/use_selected_patterns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchAlertData = alertIds => {
  const {
    selectedPatterns: oldSelectedPatterns
  } = (0, _containers.useSourcererDataView)(_constants.PageScope.alerts);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_constants.PageScope.alerts);
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const alertsQuery = (0, _react.useMemo)(() => (0, _alerts.buildAlertsQuery)(alertIds), [alertIds]);
  const {
    loading: isLoadingAlerts,
    data: alertsData
  } = (0, _use_query.useQueryAlerts)({
    query: alertsQuery,
    indexName: selectedPatterns[0],
    queryName: _constants2.ALERTS_QUERY_NAMES.CASES
  });
  const alerts = (0, _react.useMemo)(() => {
    var _alertsData$hits$hits;
    return (_alertsData$hits$hits = alertsData === null || alertsData === void 0 ? void 0 : alertsData.hits.hits.reduce((acc, {
      _id,
      _index,
      _source
    }) => ({
      ...acc,
      [_id]: {
        ...(0, _alerts.formatAlertToEcsSignal)(_source),
        _id,
        _index,
        timestamp: _source['@timestamp']
      }
    }), {})) !== null && _alertsData$hits$hits !== void 0 ? _alertsData$hits$hits : {};
  }, [alertsData === null || alertsData === void 0 ? void 0 : alertsData.hits.hits]);
  return [isLoadingAlerts, alerts];
};
exports.useFetchAlertData = useFetchAlertData;