"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAttackDiscoveryBulk = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _reactQuery = require("@kbn/react-query");
var _react = require("react");
var _constants = require("../../../../common/constants");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _kibana = require("../../../common/lib/kibana");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_find_attack_discoveries = require("../use_find_attack_discoveries");
var _use_kibana_feature_flags = require("../use_kibana_feature_flags");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useAttackDiscoveryBulk = () => {
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    attackDiscoveryPublicApiEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const invalidateFindAttackDiscoveries = (0, _use_find_attack_discoveries.useInvalidateFindAttackDiscoveries)();

  /** Disables the attack discovery schedule. */
  const attackDiscoveryBulk = (0, _react.useCallback)(() => async ({
    ids,
    kibanaAlertWorkflowStatus,
    signal,
    visibility
  }) => {
    // Build the request body differently depending on the public API feature flag
    if (attackDiscoveryPublicApiEnabled) {
      const updatePublic = {
        enable_field_rendering: true,
        // always true to enable rendering fields using the `{{ user.name james }}` syntax
        ids,
        kibana_alert_workflow_status: kibanaAlertWorkflowStatus,
        visibility,
        with_replacements: false // always false because Attack discoveries rendered in Kibana may be passed as context to a conversation, and to enable the user to see the original alert details via the `Show anonymized values` toggle
      };
      const body = {
        update: updatePublic
      };
      return _kibana.KibanaServices.get().http.post(_elasticAssistantCommon.ATTACK_DISCOVERY_BULK, {
        body: JSON.stringify(body, null, 2),
        signal,
        version: _constants.API_VERSIONS.public.v1
      });
    }

    // Internal API branch: do not include with_replacements
    const updateInternal = {
      ids,
      kibana_alert_workflow_status: kibanaAlertWorkflowStatus,
      visibility
    };
    const body = {
      update: updateInternal
    };
    return _kibana.KibanaServices.get().http.post(_elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_BULK, {
      body: JSON.stringify(body, null, 2),
      signal,
      version: _constants.API_VERSIONS.internal.v1
    });
  }, [attackDiscoveryPublicApiEnabled]);
  const mutationKey = attackDiscoveryPublicApiEnabled ? ['POST', _elasticAssistantCommon.ATTACK_DISCOVERY_BULK] : ['POST', _elasticAssistantCommon.ATTACK_DISCOVERY_INTERNAL_BULK];
  return (0, _reactQuery.useMutation)(async ({
    ids,
    kibanaAlertWorkflowStatus,
    visibility,
    signal
  }) => attackDiscoveryBulk()({
    ids,
    kibanaAlertWorkflowStatus,
    visibility,
    signal
  }), {
    mutationKey,
    onSuccess: (_, variables) => {
      const {
        ids,
        kibanaAlertWorkflowStatus
      } = variables;
      if (kibanaAlertWorkflowStatus != null) {
        invalidateFindAttackDiscoveries();
        addSuccess(i18n.MARKED_ATTACK_DISCOVERIES({
          attackDiscoveries: ids.length,
          kibanaAlertWorkflowStatus
        }));
      }
    },
    onError: error => {
      addError(error, {
        title: i18n.ERROR_UPDATING_ATTACK_DISCOVERIES
      });
    }
  });
};
exports.useAttackDiscoveryBulk = useAttackDiscoveryBulk;