"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateGetAttackDiscoverySchedule = exports.useGetAttackDiscoverySchedule = void 0;
var _react = require("react");
var _reactQuery = require("@kbn/react-query");
var _shared = require("@kbn/openapi-common/shared");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var i18n = _interopRequireWildcard(require("./translations"));
var _api = require("../api");
var _constants = require("./constants");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _use_kibana_feature_flags = require("../../../use_kibana_feature_flags");
var _schedule_type_guards = require("./schedule_type_guards");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetAttackDiscoverySchedule = params => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    attackDiscoveryPublicApiEnabled
  } = (0, _use_kibana_feature_flags.useKibanaFeatureFlags)();
  const {
    id
  } = params;
  const SPECIFIC_PATH = (0, _shared.replaceParams)(_elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID, {
    id
  });
  return (0, _reactQuery.useQuery)(['GET', SPECIFIC_PATH, params], async ({
    signal
  }) => {
    const response = await (0, _api.getAttackDiscoverySchedule)({
      attackDiscoveryPublicApiEnabled,
      signal,
      ...params
    });

    // Public API returns snake_case and needs transformation to camelCase
    // Internal API returns camelCase
    const normalizedSchedule = attackDiscoveryPublicApiEnabled ? (0, _elasticAssistantCommon.transformAttackDiscoveryScheduleFromApi)(response) : (0, _schedule_type_guards.toAttackDiscoverySchedule)(response);
    return {
      schedule: normalizedSchedule
    };
  }, {
    ..._constants.DEFAULT_QUERY_OPTIONS,
    onError: error => {
      addError(error, {
        title: i18n.FETCH_ATTACK_DISCOVERY_SCHEDULES_FAILURE()
      });
    }
  });
};

/**
 * We should use this hook to invalidate the attack discovery schedule cache. For
 * example, attack discovery schedule mutations, like create a schedule, should lead to cache invalidation.
 *
 * @returns A attack discovery schedule cache invalidation callback
 */
exports.useGetAttackDiscoverySchedule = useGetAttackDiscoverySchedule;
const useInvalidateGetAttackDiscoverySchedule = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(id => {
    const SPECIFIC_PATH = (0, _shared.replaceParams)(_elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_BY_ID, {
      id
    });

    /**
     * Invalidate all queries that start with SPECIFIC_PATH. This
     * includes the in-memory query cache and paged query cache.
     */
    queryClient.invalidateQueries(['GET', SPECIFIC_PATH], {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateGetAttackDiscoverySchedule = useInvalidateGetAttackDiscoverySchedule;