"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMaxAlerts = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * ensures maxAlerts is a positive number, otherwise returns the default value
 */
const getMaxAlerts = maxAlerts => {
  const numericMaxAlerts = Number(maxAlerts);
  const isMaxAlertsValid = Number.isInteger(numericMaxAlerts) && numericMaxAlerts > 0;
  return isMaxAlertsValid ? numericMaxAlerts : _elasticAssistant.DEFAULT_ATTACK_DISCOVERY_MAX_ALERTS;
};
exports.getMaxAlerts = getMaxAlerts;