"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttackDiscoveryTab = void 0;
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../../../common/lib/kibana");
var _attack_chain = require("./attack/attack_chain");
var _investigate_in_timeline_button = require("../../../../../../common/components/event_details/investigate_in_timeline_button");
var _actions = require("../../../../../../detections/components/alerts_table/actions");
var _helpers = require("../../../../../helpers");
var _attack_discovery_markdown_formatter = require("../../../attack_discovery_markdown_formatter");
var i18n = _interopRequireWildcard(require("./translations"));
var _view_in_ai_assistant = require("../../view_in_ai_assistant");
var _common = require("../../../../../../../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/attack_discovery_panel/tabs/attack_discovery_tab/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const scrollable = (0, _react.css)`
  overflow-x: auto;
  scrollbar-width: thin;
`;
const AttackDiscoveryTabComponent = ({
  attackDiscovery,
  replacements,
  showAnonymized = false
}) => {
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  // TODO We shouldn't have to check capabilities here, this should be done at a much higher level.
  //  https://github.com/elastic/kibana/issues/218731
  //  For the EASE we need to hide cell actions and all preview links that could open non-EASE flyouts
  const disabledActions = (0, _react2.useMemo)(() => showAnonymized || Boolean(capabilities[_common.SECURITY_FEATURE_ID].configurations), [capabilities, showAnonymized]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    detailsMarkdown,
    summaryMarkdown
  } = (0, _react2.useMemo)(() => attackDiscovery, [attackDiscovery]);
  const summaryMarkdownWithReplacements = (0, _react2.useMemo)(() => (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
    messageContent: summaryMarkdown,
    replacements: replacements !== null && replacements !== void 0 ? replacements : {}
  }), [replacements, summaryMarkdown]);
  const detailsMarkdownWithReplacements = (0, _react2.useMemo)(() => (0, _elasticAssistantCommon.replaceAnonymizedValuesWithOriginalValues)({
    messageContent: detailsMarkdown,
    replacements: replacements !== null && replacements !== void 0 ? replacements : {}
  }), [detailsMarkdown, replacements]);
  const tacticMetadata = (0, _react2.useMemo)(() => (0, _helpers.getTacticMetadata)(attackDiscovery), [attackDiscovery]);
  const originalAlertIds = (0, _react2.useMemo)(() => attackDiscovery.alertIds.map(id => {
    var _replacements$id;
    return (_replacements$id = replacements === null || replacements === void 0 ? void 0 : replacements[id]) !== null && _replacements$id !== void 0 ? _replacements$id : id;
  }), [attackDiscovery.alertIds, replacements]);
  const filters = (0, _react2.useMemo)(() => (0, _actions.buildAlertsKqlFilter)('_id', originalAlertIds), [originalAlertIds]);
  return /*#__PURE__*/_react2.default.createElement("div", {
    "data-test-subj": "attackDiscoveryTab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "summaryTitle",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, i18n.SUMMARY)), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement("div", {
    css: scrollable,
    "data-test-subj": "summaryContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_attack_discovery_markdown_formatter.AttackDiscoveryMarkdownFormatter, {
    disableActions: disabledActions,
    markdown: showAnonymized ? summaryMarkdown : summaryMarkdownWithReplacements,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "detailsTitle",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  }, i18n.DETAILS)), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react2.default.createElement("div", {
    css: scrollable,
    "data-test-subj": "detailsContent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_attack_discovery_markdown_formatter.AttackDiscoveryMarkdownFormatter, {
    disableActions: disabledActions,
    markdown: showAnonymized ? detailsMarkdown : detailsMarkdownWithReplacements,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }), tacticMetadata.length > 0 && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "attackChainTitle",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, i18n.ATTACK_CHAIN)), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_attack_chain.AttackChain, {
    attackDiscovery: attackDiscovery,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_view_in_ai_assistant.ViewInAiAssistant, {
    attackDiscovery: attackDiscovery,
    replacements: replacements,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
            margin-left: ${euiTheme.size.m};
            margin-top: ${euiTheme.size.xs};
          `,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_investigate_in_timeline_button.InvestigateInTimelineButton, {
    asEmptyButton: true,
    dataProviders: null,
    filters: filters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "investigateInTimelineButton",
    gutterSize: "xs",
    responsive: false,
    wrap: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    "data-test-subj": "timelineIcon",
    type: "timeline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "investigateInTimelineLabel",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 15
    }
  }, i18n.INVESTIGATE_IN_TIMELINE))))), /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }));
};
AttackDiscoveryTabComponent.displayName = 'AttackDiscoveryTab';
const AttackDiscoveryTab = exports.AttackDiscoveryTab = /*#__PURE__*/_react2.default.memo(AttackDiscoveryTabComponent);