"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAlertDetectionsNavigationTree = void 0;
var _constants = require("../constants");
var _link_groups = require("../link_groups");
var _links = require("../links");
var _i18n_strings = require("../i18n_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAlertDetectionsNavigationTree = ({
  sideNavVersion
} = {
  sideNavVersion: 'v1'
}) => ({
  id: _constants.SecurityGroupName.alertDetections,
  title: _link_groups.SecurityLinkGroup[_constants.SecurityGroupName.alertDetections].title,
  iconV2: 'warning',
  renderAs: 'panelOpener',
  sideNavVersion,
  children: [{
    title: _i18n_strings.i18nStrings.alertDetections.views.title,
    breadcrumbStatus: 'hidden',
    children: [{
      id: _constants.SecurityPageName.attacks,
      link: (0, _links.securityLink)(_constants.SecurityPageName.attacks)
    }, {
      id: _constants.SecurityPageName.alerts,
      link: (0, _links.securityLink)(_constants.SecurityPageName.alerts)
    }]
  }]
});
exports.createAlertDetectionsNavigationTree = createAlertDetectionsNavigationTree;