"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttackDiscoverySubFeaturesMap = exports.getAttackDiscoveryBaseKibanaSubFeatureIds = exports.AttackDiscoverySubFeatureId = void 0;
var _i18n = require("@kbn/i18n");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertingFeatures = [{
  ruleTypeId: _elasticAssistantCommon.ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID,
  consumers: [_constants.SERVER_APP_ID]
}];
const updateScheduleSubFeature = {
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.attackDiscovery.updateScheduleSubFeatureName', {
    defaultMessage: 'Schedules'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.attackDiscovery.description', {
    defaultMessage: 'Create, edit, enable, disable, or delete Attack discovery schedules.'
  }),
  privilegeGroups: [{
    groupType: 'independent',
    privileges: [{
      api: [`${_constants.APP_ID}-updateAttackDiscoverySchedule`],
      id: 'update_schedule',
      name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.attackDiscovery.updateScheduleSubFeatureDetails', {
        defaultMessage: 'Allow changes'
      }),
      includeIn: 'all',
      savedObject: {
        all: [],
        read: []
      },
      alerting: {
        rule: {
          all: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      ui: ['updateAttackDiscoverySchedule']
    }]
  }]
};
let AttackDiscoverySubFeatureId = exports.AttackDiscoverySubFeatureId = /*#__PURE__*/function (AttackDiscoverySubFeatureId) {
  AttackDiscoverySubFeatureId["updateSchedule"] = "updateScheduleSubFeature";
  return AttackDiscoverySubFeatureId;
}({});
/**
 * Sub-features that will always be available for Security Attack discovery
 * regardless of the product type.
 */
const getAttackDiscoveryBaseKibanaSubFeatureIds = () => [];

/**
 * Defines all the Security Attack discovery subFeatures available.
 * The order of the subFeatures is the order they will be displayed
 */
exports.getAttackDiscoveryBaseKibanaSubFeatureIds = getAttackDiscoveryBaseKibanaSubFeatureIds;
const getAttackDiscoverySubFeaturesMap = experimentalFeatures => {
  const attackDiscoverySubFeaturesList = [[AttackDiscoverySubFeatureId.updateSchedule, updateScheduleSubFeature]];

  // Use the following code to add feature based on feature flag
  // if (experimentalFeatures.featureFlagName) {
  //   attackDiscoverySubFeaturesList.push([AttackDiscoverySubFeatureId.featureId, featureSubFeature]);
  // }

  const attackDiscoverySubFeaturesMap = new Map(attackDiscoverySubFeaturesList);
  return Object.freeze(attackDiscoverySubFeaturesMap);
};
exports.getAttackDiscoverySubFeaturesMap = getAttackDiscoverySubFeaturesMap;