"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorUnconfigured = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/scheduling/connector_unconfigured.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ConnectorUnconfigured = ({
  configurationPathOnClick,
  dataTelemetryIdPrefix
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "info",
    title: _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.notConnected.title', {
      defaultMessage: 'Configure your connector to schedule a sync'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.notConnected.description', {
    defaultMessage: 'Configure and deploy your connector, then return here to set your sync schedule. This schedule will dictate the interval that the connector will sync with your data source for updated documents.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": `${dataTelemetryIdPrefix}-connector-scheduling-configure`,
    onClick: configurationPathOnClick,
    fill: true,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.notConnected.button.label', {
    defaultMessage: 'Configure'
  }))));
};
exports.ConnectorUnconfigured = ConnectorUnconfigured;