"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveSearchSavedObject = exports.saveSavedSearch = void 0;
var _constants = require("./constants");
var _saved_searches_utils = require("../../common/service/saved_searches_utils");
var _check_for_duplicate_title = require("./check_for_duplicate_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const saveSearchSavedObject = async (id, attributes, references, contentManagement) => {
  const resp = id ? await contentManagement.update({
    contentTypeId: _constants.SAVED_SEARCH_TYPE,
    id,
    data: attributes,
    options: {
      references
    }
  }) : await contentManagement.create({
    contentTypeId: _constants.SAVED_SEARCH_TYPE,
    data: attributes,
    options: {
      references
    }
  });
  return resp.item.id;
};

/** @internal **/
exports.saveSearchSavedObject = saveSearchSavedObject;
const saveSavedSearch = async (savedSearch, options, contentManagement, savedObjectsTagging) => {
  var _savedSearch$tags;
  const isNew = options.copyOnSave || !savedSearch.id;
  if (isNew) {
    try {
      await (0, _check_for_duplicate_title.checkForDuplicateTitle)({
        title: savedSearch.title,
        isTitleDuplicateConfirmed: options.isTitleDuplicateConfirmed,
        onTitleDuplicate: options.onTitleDuplicate,
        contentManagement
      });
    } catch {
      return;
    }
  }
  const {
    searchSourceJSON,
    references: originalReferences
  } = savedSearch.searchSource.serialize();
  const references = savedObjectsTagging ? savedObjectsTagging.ui.updateTagsReferences(originalReferences, (_savedSearch$tags = savedSearch.tags) !== null && _savedSearch$tags !== void 0 ? _savedSearch$tags : []) : originalReferences;
  return saveSearchSavedObject(isNew ? undefined : savedSearch.id, (0, _saved_searches_utils.toSavedSearchAttributes)(savedSearch, searchSourceJSON), references, contentManagement);
};
exports.saveSavedSearch = saveSavedSearch;