"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetSavedSearchDeps = void 0;
var _coreHttpBrowser = require("@kbn/core-http-browser");
var _public = require("@kbn/kibana-utils-plugin/public");
var _content_management = require("../../common/content_management");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createGetSavedSearchDeps = ({
  spaces,
  savedObjectsTaggingOss,
  search,
  contentManagement
}) => ({
  spaces,
  savedObjectsTagging: savedObjectsTaggingOss === null || savedObjectsTaggingOss === void 0 ? void 0 : savedObjectsTaggingOss.getTaggingApi(),
  searchSourceCreate: search.searchSource.create,
  getSavedSrch: id => {
    return contentManagement.get({
      contentTypeId: _content_management.SavedSearchType,
      id
    });
  },
  handleGetSavedSrchError: (error, savedSearchId) => {
    var _error$response;
    if ((0, _coreHttpBrowser.isHttpFetchError)(error) && ((_error$response = error.response) === null || _error$response === void 0 ? void 0 : _error$response.status) === 404) {
      throw new _public.SavedObjectNotFound({
        type: _constants.SAVED_SEARCH_TYPE,
        typeDisplayName: 'Discover session',
        id: savedSearchId
      });
    }
  }
});
exports.createGetSavedSearchDeps = createGetSavedSearchDeps;