"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractTabs = extractTabs;
exports.extractTabsBackfillFn = void 0;
var _uuid = require("uuid");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const extractTabsBackfillFn = prevDoc => {
  const attributes = extractTabs(prevDoc.attributes);
  return {
    attributes
  };
};

// Don't change this, it's used to generate deterministic UUIDs for
// the default tab when backfilling pre-tab to tabbed Discover sessions
exports.extractTabsBackfillFn = extractTabsBackfillFn;
const DEFAULT_TAB_UUID_NAMESPACE = '617f8ea7-754a-4a75-86bf-58c4b2f99690';

/**
 * Extract tab attributes into a separate array since multiple tabs are supported
 * @param attributes The previous attributes to be transformed (version 5)
 * @param discoverSessionId Optional Discover session ID used to generate a deterministic UUID for the default tab
 */
function extractTabs(attributes, discoverSessionId) {
  const {
    title,
    description,
    ...tabAttrs
  } = attributes;
  const id = discoverSessionId ? (0, _uuid.v5)(discoverSessionId, DEFAULT_TAB_UUID_NAMESPACE) : (0, _uuid.v4)();
  const tabs = [{
    id,
    label: _i18n.i18n.translate('savedSearch.defaultTabLabel', {
      defaultMessage: 'Untitled'
    }),
    attributes: (0, _lodash.omit)(tabAttrs, 'tabs')
  }];
  return {
    ...attributes,
    tabs
  };
}