"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingDataAccessPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _register_services = require("./services/register_services");
var _create_profiling_es_client = require("./utils/create_profiling_es_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ProfilingDataAccessPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.initializerContext = initializerContext;
    this.logger = initializerContext.logger.get();
  }
  setup(core) {}
  start(core, plugins) {
    const config = this.initializerContext.config.get();
    const profilingSpecificEsClient = config.elasticsearch ? core.elasticsearch.createClient('profiling', {
      hosts: [config.elasticsearch.hosts],
      username: config.elasticsearch.username,
      password: config.elasticsearch.password
    }) : undefined;
    const services = (0, _register_services.registerServices)({
      createProfilingEsClient: ({
        esClient: defaultEsClient,
        useDefaultAuth = false
      }) => {
        const esClient = profilingSpecificEsClient && !useDefaultAuth ? profilingSpecificEsClient.asInternalUser : defaultEsClient;
        return (0, _create_profiling_es_client.createProfilingEsClient)({
          esClient
        });
      },
      logger: this.logger,
      deps: {
        fleet: plugins.fleet,
        cloud: plugins.cloud
      }
    });

    // called after all plugins are set up
    return {
      services
    };
  }
}
exports.ProfilingDataAccessPlugin = ProfilingDataAccessPlugin;