"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTextAttachmentType = void 0;
var _attachments = require("@kbn/onechat-common/attachments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates the definition for the `text` attachment type.
 */
const createTextAttachmentType = () => {
  return {
    id: _attachments.AttachmentType.text,
    validate: input => {
      const parseResult = _attachments.textAttachmentDataSchema.safeParse(input);
      if (parseResult.success) {
        return {
          valid: true,
          data: parseResult.data
        };
      } else {
        return {
          valid: false,
          error: parseResult.error.message
        };
      }
    },
    format: attachment => {
      return {
        getRepresentation: () => {
          return {
            type: 'text',
            value: attachment.data.content
          };
        }
      };
    },
    getTools: () => []
  };
};
exports.createTextAttachmentType = createTextAttachmentType;