"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableConversationHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _use_conversation = require("../application/hooks/use_conversation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/embeddable/embeddable_conversation_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  ariaLabel: _i18n.i18n.translate('xpack.onechat.embeddable.conversationHeader.ariaLabel', {
    defaultMessage: 'Conversation title'
  }),
  newConversationDisplay: _i18n.i18n.translate('xpack.onechat.embeddable.conversationHeader.newConversationDisplay', {
    defaultMessage: 'New conversation'
  })
};
const containerStyles = (0, _react2.css)`
  display: flex;
  justify-content: space-between;
  align-items: center;
  width: 100%;
`;
const EmbeddableConversationHeader = ({
  onClose,
  ariaLabelledBy
}) => {
  const {
    title,
    isLoading
  } = (0, _use_conversation.useConversationTitle)();
  const titleDisplayText = isLoading ? '' : title || labels.newConversationDisplay;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: containerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "aria-label": labels.ariaLabel,
    size: "xxs",
    "data-test-subj": "agentBuilderEmbeddableConversationTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: ariaLabelledBy,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, titleDisplayText)), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    onClick: onClose,
    "aria-label": _i18n.i18n.translate('xpack.onechat.embeddable.conversationHeader.closeLabel', {
      defaultMessage: 'Close'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
};
exports.EmbeddableConversationHeader = EmbeddableConversationHeader;