"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.relevanceSearch = void 0;
var _steps = require("./steps");
var _resources = require("./utils/resources");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const relevanceSearch = async ({
  term,
  target,
  size = 10,
  model,
  esClient
}) => {
  const {
    fields
  } = await (0, _resources.resolveResource)({
    resourceName: target,
    esClient
  });
  const selectedFields = fields.filter(field => field.type === 'text' || field.type === 'semantic_text');
  if (selectedFields.length === 0) {
    throw new Error('No text or semantic_text fields found, aborting search.');
  }
  return (0, _steps.performMatchSearch)({
    term,
    index: target,
    fields: selectedFields,
    size,
    esClient
  });
};
exports.relevanceSearch = relevanceSearch;