"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.matchName = exports.matchGraphNode = exports.matchGraphName = exports.matchEvent = exports.isStreamEvent = exports.hasTag = exports.createToolResultEvent = exports.createToolCallEvent = exports.createThinkingCompleteEvent = exports.createTextChunkEvent = exports.createReasoningEvent = exports.createMessageEvent = exports.createBrowserToolCallEvent = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isStreamEvent = input => {
  return 'event' in input && 'name' in input;
};
exports.isStreamEvent = isStreamEvent;
const matchGraphName = (event, graphName) => {
  return event.metadata.graphName === graphName;
};
exports.matchGraphName = matchGraphName;
const matchGraphNode = (event, nodeName) => {
  return event.metadata.langgraph_node === nodeName;
};
exports.matchGraphNode = matchGraphNode;
const matchEvent = (event, eventName) => {
  return event.event === eventName;
};
exports.matchEvent = matchEvent;
const matchName = (event, name) => {
  return event.name === name;
};
exports.matchName = matchName;
const hasTag = (event, tag) => {
  var _event$tags;
  return ((_event$tags = event.tags) !== null && _event$tags !== void 0 ? _event$tags : []).includes(tag);
};
exports.hasTag = hasTag;
const createToolCallEvent = data => {
  return {
    type: _onechatCommon.ChatEventType.toolCall,
    data: {
      tool_call_id: data.toolCallId,
      tool_id: data.toolId,
      params: data.params
    }
  };
};
exports.createToolCallEvent = createToolCallEvent;
const createBrowserToolCallEvent = data => {
  return {
    type: _onechatCommon.ChatEventType.browserToolCall,
    data: {
      tool_call_id: data.toolCallId,
      tool_id: data.toolId,
      params: data.params
    }
  };
};
exports.createBrowserToolCallEvent = createBrowserToolCallEvent;
const createToolResultEvent = data => {
  return {
    type: _onechatCommon.ChatEventType.toolResult,
    data: {
      tool_call_id: data.toolCallId,
      tool_id: data.toolId,
      results: data.results
    }
  };
};
exports.createToolResultEvent = createToolResultEvent;
const createTextChunkEvent = (chunk, {
  messageId = 'unknown'
} = {}) => {
  return {
    type: _onechatCommon.ChatEventType.messageChunk,
    data: {
      message_id: messageId,
      text_chunk: chunk
    }
  };
};
exports.createTextChunkEvent = createTextChunkEvent;
const createMessageEvent = (content, {
  messageId = 'unknown'
} = {}) => {
  return {
    type: _onechatCommon.ChatEventType.messageComplete,
    data: {
      message_id: messageId,
      message_content: content
    }
  };
};
exports.createMessageEvent = createMessageEvent;
const createReasoningEvent = (reasoning, {
  transient
} = {}) => {
  return {
    type: _onechatCommon.ChatEventType.reasoning,
    data: {
      reasoning,
      transient
    }
  };
};
exports.createReasoningEvent = createReasoningEvent;
const createThinkingCompleteEvent = timeToFirstToken => {
  return {
    type: _onechatCommon.ChatEventType.thinkingComplete,
    data: {
      time_to_first_token: timeToFirstToken
    }
  };
};
exports.createThinkingCompleteEvent = createThinkingCompleteEvent;