"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.alertsSuggestedDashboardRepository = void 0;
var _observabilitySchema = require("@kbn/observability-schema");
var _constants = require("../../../common/constants");
var _create_observability_server_route = require("../create_observability_server_route");
var _related_dashboards_client = require("../../services/related_dashboards_client");
var _investigate_alerts_client = require("../../services/investigate_alerts_client");
var _alert_not_found_error = require("../../common/errors/alert_not_found_error");
var _referenced_panel_manager = require("../../services/referenced_panel_manager");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertsDynamicDashboardSuggestions = (0, _create_observability_server_route.createObservabilityServerRoute)({
  endpoint: `GET ${_constants.ALERTS_API_URLS.INTERNAL_RELATED_DASHBOARDS}`,
  security: {
    authz: {
      enabled: false,
      reason: 'This route is opted out from authorization because it is a wrapper around Saved Object client'
    }
  },
  options: {
    access: 'internal'
  },
  params: _observabilitySchema.getRelatedDashboardsParamsSchema,
  handler: async services => {
    const {
      dependencies,
      params,
      request,
      response,
      context,
      logger
    } = services;
    const {
      alertId
    } = params.query;
    const {
      ruleRegistry,
      dashboard
    } = dependencies;
    const {
      getDashboard,
      scanDashboards
    } = dashboard;
    const {
      savedObjects
    } = await context.core;
    const alertsClient = await ruleRegistry.getRacClientWithRequest(request);
    const rulesClient = await ruleRegistry.alerting.getRulesClientWithRequest(request);
    const investigateAlertsClient = new _investigate_alerts_client.InvestigateAlertsClient(alertsClient, rulesClient);
    const referencedPanelManager = new _referenced_panel_manager.ReferencedPanelManager(logger, savedObjects.client);
    const dashboardParser = new _related_dashboards_client.RelatedDashboardsClient(logger, id => getDashboard(context, id), (page, perPage) => scanDashboards(context, page, perPage), investigateAlertsClient, alertId, referencedPanelManager);
    try {
      const {
        suggestedDashboards,
        linkedDashboards
      } = await dashboardParser.fetchRelatedDashboards();
      return {
        suggestedDashboards,
        linkedDashboards
      };
    } catch (e) {
      if (e instanceof _alert_not_found_error.AlertNotFoundError) {
        return response.badRequest({
          body: {
            message: e.message
          }
        });
      }
      throw e;
    }
  }
});
const alertsSuggestedDashboardRepository = exports.alertsSuggestedDashboardRepository = alertsDynamicDashboardSuggestions;