"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDescriptionFields = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDescriptionFields = ({
  rule,
  prebuildFields
}) => {
  if (!rule || !prebuildFields) return [];
  const searchConfig = rule.params.searchConfiguration;
  if (!searchConfig) return [];
  const fields = [];
  if (typeof searchConfig.index === 'string') {
    fields.push(prebuildFields.dataViewIndexPattern(searchConfig.index));
  }
  if (searchConfig.query.query) {
    fields.push(prebuildFields.customQuery(searchConfig.query.query));
  }
  if (searchConfig.filter && typeof searchConfig.index === 'string') {
    fields.push(prebuildFields.queryFilters({
      filters: searchConfig.filter,
      dataViewId: searchConfig.index
    }));
  }
  return fields;
};
exports.getDescriptionFields = getDescriptionFields;