"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTab = RulesTab;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-utils-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _constants = require("../../../common/constants");
var _common = require("../../../common");
var _kibana_react = require("../../utils/kibana_react");
var _use_get_filtered_rule_types = require("../../hooks/use_get_filtered_rule_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/rules/rules_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RulesTab({
  setRefresh,
  stateRefresh
}) {
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    ruleTypeRegistry,
    actionTypeRegistry,
    triggersActionsUi: {
      getRulesList: RuleList
    }
  } = (0, _kibana_react.useKibana)().services;
  const history = (0, _reactRouterDom.useHistory)();
  const urlStateStorage = (0, _public.createKbnUrlStateStorage)({
    history,
    useHash: false,
    useHashQuery: false
  });
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const {
    lastResponse,
    params,
    search,
    status,
    type
  } = urlStateStorage.get('_a') || {
    lastResponse: [],
    params: {},
    search: '',
    status: [],
    type: []
  };
  const [stateLastResponse, setLastResponse] = (0, _react.useState)(lastResponse);
  const [stateParams, setParams] = (0, _react.useState)(params);
  const [stateSearch, setSearch] = (0, _react.useState)(search);
  const [stateStatus, setStatus] = (0, _react.useState)(status);
  const [stateType, setType] = (0, _react.useState)(type);
  const [ruleConditionsFlyoutOpen, setRuleConditionsFlyoutOpen] = (0, _react.useState)(false);
  const [ruleIdToEdit, setRuleIdToEdit] = (0, _react.useState)();
  const handleStatusFilterChange = newStatus => {
    setStatus(newStatus);
    urlStateStorage.set('_a', {
      lastResponse,
      params,
      search,
      status: newStatus,
      type
    });
  };
  const handleLastRunOutcomeFilterChange = newLastResponse => {
    setRefresh(new Date());
    setLastResponse(newLastResponse);
    urlStateStorage.set('_a', {
      lastResponse: newLastResponse,
      params,
      search,
      status,
      type
    });
  };
  const handleTypeFilterChange = newType => {
    setType(newType);
    urlStateStorage.set('_a', {
      lastResponse,
      params,
      search,
      status,
      type: newType
    });
  };
  const handleSearchFilterChange = newSearch => {
    setSearch(newSearch);
    urlStateStorage.set('_a', {
      lastResponse,
      params,
      search: newSearch,
      status,
      type
    });
  };
  const handleRuleParamFilterChange = newParams => {
    setParams(newParams);
    urlStateStorage.set('_a', {
      lastResponse,
      params: newParams,
      search,
      status,
      type
    });
  };
  const navigateToEditRuleForm = ruleId => {
    setRuleIdToEdit(ruleId);
    setRuleConditionsFlyoutOpen(true);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(RuleList, {
    ruleTypeIds: _constants.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    consumers: _common.observabilityAlertFeatureIds,
    filteredRuleTypes: filteredRuleTypes,
    lastRunOutcomeFilter: stateLastResponse,
    refresh: stateRefresh,
    ruleDetailsRoute: "alerts/rules/:ruleId",
    rulesListKey: "observability_rulesListColumns",
    ruleParamFilter: stateParams,
    showActionFilter: false,
    statusFilter: stateStatus,
    searchFilter: stateSearch,
    typeFilter: stateType,
    navigateToEditRuleForm: navigateToEditRuleForm,
    visibleColumns: ['ruleName', 'ruleExecutionStatusLastDate', 'ruleSnoozeNotify', 'ruleExecutionStatus', 'ruleExecutionState'],
    onLastRunOutcomeFilterChange: handleLastRunOutcomeFilterChange,
    onRuleParamFilterChange: handleRuleParamFilterChange,
    onSearchFilterChange: handleSearchFilterChange,
    onStatusFilterChange: handleStatusFilterChange,
    onTypeFilterChange: handleTypeFilterChange,
    initialSelectedConsumer: _ruleDataUtils.AlertConsumers.LOGS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), ruleIdToEdit && ruleConditionsFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
    plugins: {
      ...services,
      ruleTypeRegistry,
      actionTypeRegistry
    },
    id: ruleIdToEdit,
    onCancel: () => {
      setRuleConditionsFlyoutOpen(false);
      setRuleIdToEdit(null);
    },
    onSubmit: () => {
      setRuleConditionsFlyoutOpen(false);
      setRuleIdToEdit(null);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }) : null);
}