"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.recallRankingEventType = exports.recallRankingEvent = void 0;
var _analytics = require("../../common/analytics");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const schema = {
  scoredDocuments: {
    type: 'array',
    items: {
      properties: {
        esScore: {
          type: 'float',
          _meta: {
            description: 'The score produced by Elasticsearch'
          }
        },
        llmScore: {
          type: 'integer',
          _meta: {
            description: 'The score produced by the LLM when asked to rerank'
          }
        },
        connector: {
          properties: _analytics.connectorSchema
        },
        scopes: _analytics.scopeSchema
      }
    }
  }
};
const recallRankingEventType = exports.recallRankingEventType = 'observability_ai_assistant_recall_ranking';
const recallRankingEvent = exports.recallRankingEvent = {
  eventType: recallRankingEventType,
  schema
};