"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.vents = exports._vents = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const _vents = exports._vents = {};
const vents = exports.vents = {
  vents: _vents,
  on: function (id, cb) {
    if (!(0, _lodash.isArray)(_vents[id])) {
      _vents[id] = [];
    }
    _vents[id].push(cb);
  },
  clear: function (id) {
    delete _vents[id];
  },
  trigger: function () {
    const args = Array.prototype.slice.call(arguments);
    const id = args.shift();
    if (_vents[id]) {
      (0, _lodash.each)(_vents[id], function (cb) {
        cb.apply(null, args);
      });
    }
  }
};