"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyJobSelectorEmptyState = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/maps/anomaly_job_selector_empty_state.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AnomalyJobSelectorEmptyState = ({
  jobsManagementPath,
  canCreateJobs
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  layout: "vertical",
  hasBorder: false,
  hasShadow: false,
  color: "subdued",
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.mapsAnomaliesLayerEmptyPrompt.createJobMessage",
    defaultMessage: "Create an anomaly detection job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 9
    }
  })),
  body: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.mapsAnomaliesLayerEmptyPrompt.emptyPromptText",
    defaultMessage: "Anomaly detection enables you to find unusual behaviour in your geographic data. Create a job that uses the lat_long function, which is necessary for the maps anomaly layer.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  })),
  actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    href: jobsManagementPath,
    fill: true,
    iconType: "plusInCircle",
    isDisabled: !canCreateJobs,
    "data-test-subj": "mlMapsCreateNewJobButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.mapsAnomaliesLayerEmptyPrompt.createJobButtonText",
    defaultMessage: "Create job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  })),
  "data-test-subj": "mlMapsAnomalyDetectionEmptyState",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 3
  }
});
exports.AnomalyJobSelectorEmptyState = AnomalyJobSelectorEmptyState;