"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSeriesChartWithTooltips = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _chart_tooltip = require("../../../components/chart_tooltip");
var _timeseries_chart = require("./timeseries_chart");
var _search = require("../../../../../common/constants/search");
var _kibana = require("../../../contexts/kibana");
var _time_buckets_service = require("../../../util/time_buckets_service");
var _get_controls_for_detector = require("../../get_controls_for_detector");
var _ml_annotation_updates_context = require("../../../contexts/ml/ml_annotation_updates_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/components/timeseries_chart/timeseries_chart_with_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TimeSeriesChartWithTooltips = ({
  bounds,
  detectorIndex,
  embeddableMode,
  renderFocusChartOnly,
  selectedJob,
  selectedEntities,
  showAnnotations,
  showForecast,
  showModelBounds,
  chartProps,
  lastRefresh,
  contextAggregationInterval,
  tableData = {
    anomalies: [],
    interval: 'second'
  },
  sourceIndicesWithGeoFields
}) => {
  const {
    toasts: toastNotifications
  } = (0, _kibana.useNotifications)();
  const {
    services: {
      mlServices: {
        mlApi
      }
    }
  } = (0, _kibana.useMlKibana)();
  const annotationUpdatesService = (0, _react.useContext)(_ml_annotation_updates_context.MlAnnotationUpdatesContext);
  const [annotationData, setAnnotationData] = (0, _react.useState)([]);
  const showAnnotationErrorToastNotification = (0, _react.useCallback)(error => {
    toastNotifications.addDanger({
      title: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.mlSingleMetricViewerChart.annotationsErrorTitle', {
        defaultMessage: 'An error occurred fetching annotations'
      }),
      ...(error ? {
        text: (0, _mlErrorUtils.extractErrorMessage)(error)
      } : {})
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const mlTimeBucketsService = (0, _time_buckets_service.useTimeBucketsService)();
  (0, _react.useEffect)(() => {
    let unmounted = false;
    const entities = (0, _get_controls_for_detector.getControlsForDetector)(detectorIndex, selectedEntities, selectedJob);
    const nonBlankEntities = Array.isArray(entities) ? entities.filter(entity => entity.fieldValue !== null) : undefined;
    const searchBounds = mlTimeBucketsService.getBoundsRoundedToInterval(bounds, contextAggregationInterval, false);

    /**
     * Loads the full list of annotations for job without any aggs or time boundaries
     * used to indicate existence of annotations that are beyond the selected time
     * in the time series brush area
     */
    const loadAnnotations = async jobId => {
      try {
        const resp = await mlApi.annotations.getAnnotations({
          jobIds: [jobId],
          earliestMs: searchBounds.min.valueOf(),
          latestMs: searchBounds.max.valueOf(),
          maxAnnotations: _search.ANNOTATIONS_TABLE_DEFAULT_QUERY_SIZE,
          detectorIndex,
          entities: nonBlankEntities
        });
        if (!unmounted) {
          if (Array.isArray(resp.annotations[jobId])) {
            setAnnotationData(resp.annotations[jobId]);
          }
        }
      } catch (error) {
        showAnnotationErrorToastNotification(error);
      }
    };
    loadAnnotations(selectedJob.job_id);
    return () => {
      unmounted = true;
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedJob.job_id, detectorIndex, lastRefresh, selectedEntities, bounds, contextAggregationInterval]);
  if (chartProps.svgHeight) {
    // 32 accounts for the height of the chart title
    chartProps.svgHeight -= 32;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "ml-timeseries-chart",
    "data-test-subj": "mlSingleMetricViewerChart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_tooltip.MlTooltipComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, tooltipService => /*#__PURE__*/_react.default.createElement(_timeseries_chart.TimeseriesChart, (0, _extends2.default)({}, chartProps, {
    annotationUpdatesService: annotationUpdatesService,
    annotationData: annotationData,
    bounds: bounds,
    detectorIndex: detectorIndex,
    embeddableMode: embeddableMode,
    renderFocusChartOnly: renderFocusChartOnly,
    selectedJob: selectedJob,
    showAnnotations: showAnnotations,
    showForecast: showForecast,
    showModelBounds: showModelBounds,
    tooltipService: tooltipService,
    tableData: tableData,
    sourceIndicesWithGeoFields: sourceIndicesWithGeoFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }))));
};
exports.TimeSeriesChartWithTooltips = TimeSeriesChartWithTooltips;