"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorerUrlStateManager = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _kibana = require("../../../contexts/kibana");
var _use_refresh = require("../../use_refresh");
var _explorer = require("../../../explorer");
var _use_job_selection = require("../../../components/job_selector/use_job_selection");
var _select_severity = require("../../../components/controls/select_severity");
var _page_header = require("../../../components/page_header");
var _page_title = require("../../../components/page_title");
var _anomaly_results_view_selector = require("../../../components/anomaly_results_view_selector");
var _anomaly_detection_empty_state = require("../../../jobs/jobs_list/components/anomaly_detection_empty_state");
var _anomaly_explorer_context = require("../../../explorer/anomaly_explorer_context");
var _explorer_utils = require("../../../explorer/explorer_utils");
var _job_service = require("../../../services/job_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/routing/routes/explorer/state_manager.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExplorerUrlStateManager = ({
  jobsWithTimeRange
}) => {
  var _cases$ui$getCasesCon;
  const {
    services: {
      cases,
      uiSettings,
      mlServices
    }
  } = (0, _kibana.useMlKibana)();
  const {
    mlApi
  } = mlServices;
  const [stoppedPartitions, setStoppedPartitions] = (0, _react.useState)();
  const timeBuckets = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: true,
    autoRefreshSelector: true
  });
  const mlJobService = (0, _job_service.useMlJobService)();
  const {
    selectedIds: jobIds,
    selectedJobs
  } = (0, _use_job_selection.useJobSelection)(jobsWithTimeRange);
  const noInfluencersConfigured = (0, _explorer_utils.getInfluencers)(mlJobService, selectedJobs).length === 0;
  const selectedJobsRunning = jobsWithTimeRange.some(job => (jobIds === null || jobIds === void 0 ? void 0 : jobIds.includes(job.id)) && job.isRunning === true);
  const anomalyExplorerContext = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const refresh = (0, _use_refresh.useRefresh)();
  const getJobsWithStoppedPartitions = (0, _react.useCallback)(async selectedJobIds => {
    try {
      const fetchedStoppedPartitions = await mlApi.results.getCategoryStoppedPartitions(selectedJobIds, _mlAnomalyUtils.ML_JOB_ID);
      if (fetchedStoppedPartitions && Array.isArray(fetchedStoppedPartitions.jobs) && fetchedStoppedPartitions.jobs.length > 0) {
        setStoppedPartitions(fetchedStoppedPartitions.jobs);
      } else {
        setStoppedPartitions(undefined);
      }
    } catch (error) {
      // eslint-disable-next-line no-console
      console.error(error);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    if (jobIds && jobIds.length > 0) {
      getJobsWithStoppedPartitions(jobIds);
    }
  }, [getJobsWithStoppedPartitions, jobIds]);
  const [tableSeverity] = (0, _select_severity.useTableSeverity)();
  const showCharts = (0, _useObservable.default)(anomalyExplorerContext.chartsStateService.getShowCharts$(), anomalyExplorerContext.chartsStateService.getShowCharts());
  const selectedCells = (0, _useObservable.default)(anomalyExplorerContext.anomalyTimelineStateService.getSelectedCells$(), anomalyExplorerContext.anomalyTimelineStateService.getSelectedCells());
  const swimLaneSeverity = (0, _useObservable.default)(anomalyExplorerContext.anomalyTimelineStateService.getSwimLaneSeverity$(), anomalyExplorerContext.anomalyTimelineStateService.getSwimLaneSeverity());
  const overallSwimlaneData = (0, _useObservable.default)(anomalyExplorerContext.anomalyTimelineStateService.getOverallSwimLaneData$(), null);
  if (refresh === undefined) {
    return null;
  }
  const CasesContext = (_cases$ui$getCasesCon = cases === null || cases === void 0 ? void 0 : cases.ui.getCasesContext()) !== null && _cases$ui$getCasesCon !== void 0 ? _cases$ui$getCasesCon : _react.default.Fragment;
  const casesPermissions = cases === null || cases === void 0 ? void 0 : cases.helpers.canUseCases();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "ml-explorer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    leftSideItems: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_anomaly_results_view_selector.AnomalyResultsViewSelector, {
      viewId: "explorer",
      selectedJobs: selectedJobs,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 15
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: _i18n.i18n.translate('xpack.ml.explorer.pageTitle', {
      defaultMessage: 'Anomaly Explorer'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(CasesContext, {
    owner: [],
    permissions: casesPermissions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 7
    }
  }, jobsWithTimeRange.length === 0 ? /*#__PURE__*/_react.default.createElement(_anomaly_detection_empty_state.AnomalyDetectionEmptyState, {
    showDocsLink: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_explorer.Explorer, {
    noInfluencersConfigured,
    overallSwimlaneData,
    showCharts,
    severity: tableSeverity.val,
    stoppedPartitions,
    selectedJobsRunning,
    timeBuckets,
    timefilter,
    selectedCells,
    swimLaneSeverity,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 11
    }
  })));
};
exports.ExplorerUrlStateManager = ExplorerUrlStateManager;