"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewPanelDefaultState = exports.default = exports.OverviewPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _common = require("@kbn/field-formats-plugin/common");
var _mlUrlState = require("@kbn/ml-url-state");
var _collapsible_panel = require("../components/collapsible_panel/collapsible_panel");
var _storage = require("../../../common/types/storage");
var _collapsible_panel2 = require("../components/collapsible_panel");
var _check_capabilities = require("../capabilities/check_capabilities");
var _ml_nodes_check = require("../ml_nodes_check");
var _content = require("./components/content");
var _node_available_warning = require("../components/node_available_warning");
var _jobs_awaiting_node_warning = require("../components/jobs_awaiting_node_warning");
var _saved_objects_warning = require("../components/saved_objects_warning");
var _upgrade = require("../components/upgrade");
var _help_menu = require("../components/help_menu");
var _kibana = require("../contexts/kibana");
var _ml_notifications_context = require("../contexts/ml/ml_notifications_context");
var _nodes_overview = require("../memory_usage/nodes_overview");
var _page_header = require("../components/page_header");
var _page_title = require("../components/page_title");
var _check_ml_nodes = require("../ml_nodes_check/check_ml_nodes");
var _memory_page = require("../memory_usage/memory_tree_map/memory_page");
var _notifications_list = require("../notifications/components/notifications_list");
var _use_memory_usage = require("../memory_usage/use_memory_usage");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/overview/overview_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const overviewPanelDefaultState = exports.overviewPanelDefaultState = Object.freeze({
  nodes: true,
  adJobs: true,
  dfaJobs: true
});
const overviewPanelExtendedDefaultState = Object.freeze({
  memoryUsage: true
});
const MEMORY_STATS_LABELS = {
  'anomaly-detector': _i18n.i18n.translate('xpack.ml.overview.memoryUsagePanel.anomalyDetectionLabel', {
    defaultMessage: 'Anomaly detection'
  }),
  'data-frame-analytics': _i18n.i18n.translate('xpack.ml.overview.memoryUsagePanel.dataFrameAnalyticsLabel', {
    defaultMessage: 'Data frame analytics'
  }),
  'trained-model': _i18n.i18n.translate('xpack.ml.overview.memoryUsagePanel.trainedModelsLabel', {
    defaultMessage: 'Trained models'
  })
};
var TAB_IDS = /*#__PURE__*/function (TAB_IDS) {
  TAB_IDS["OVERVIEW"] = "overview";
  TAB_IDS["NOTIFICATIONS"] = "notifications";
  return TAB_IDS;
}(TAB_IDS || {});
const OverviewPage = ({
  timefilter
}) => {
  var _notificationsCounts$, _notificationsCounts$2, _pageState$tab, _tabs$find;
  const [canViewMlNodes, canCreateJob] = (0, _check_capabilities.usePermissionCheck)(['canViewMlNodes', 'canCreateJob']);
  const disableCreateAnomalyDetectionJob = !canCreateJob || !(0, _ml_nodes_check.mlNodesAvailable)();
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const helpLink = docLinks.links.ml.guide;
  const {
    data: memoryUsageData,
    error: memoryUsageError,
    loading: memoryUsageLoading
  } = (0, _use_memory_usage.useMemoryUsage)();
  const bytesFormatter = (0, _kibana.useFieldFormatter)(_common.FIELD_FORMAT_IDS.BYTES);
  const {
    notificationsCounts
  } = (0, _ml_notifications_context.useMlNotifications)();
  const errorsAndWarningCount = ((_notificationsCounts$ = notificationsCounts === null || notificationsCounts === void 0 ? void 0 : notificationsCounts.error) !== null && _notificationsCounts$ !== void 0 ? _notificationsCounts$ : 0) + ((_notificationsCounts$2 = notificationsCounts === null || notificationsCounts === void 0 ? void 0 : notificationsCounts.warning) !== null && _notificationsCounts$2 !== void 0 ? _notificationsCounts$2 : 0);
  const [pageState, setPageState] = (0, _mlUrlState.useUrlState)('_g');
  const selectedTabId = (_pageState$tab = pageState === null || pageState === void 0 ? void 0 : pageState.tab) !== null && _pageState$tab !== void 0 ? _pageState$tab : TAB_IDS.OVERVIEW;
  const setSelectedTabId = tabId => {
    setPageState({
      tab: tabId
    });
  };
  const [adLazyJobCount, setAdLazyJobCount] = (0, _react.useState)(0);
  const [dfaLazyJobCount, setDfaLazyJobCount] = (0, _react.useState)(0);
  const [memoryUsageStats, setMemoryUsageStats] = (0, _react.useState)([]);
  const [panelsState, setPanelsState] = (0, _mlLocalStorage.useStorage)(_storage.ML_OVERVIEW_PANELS, overviewPanelDefaultState);
  const [panelsExtendedState, setPanelsExtendedState] = (0, _mlLocalStorage.useStorage)(_storage.ML_OVERVIEW_PANELS_EXTENDED, overviewPanelExtendedDefaultState);
  (0, _react.useEffect)(function setUpMemoryUsageStats() {
    if (memoryUsageLoading || memoryUsageError) return;
    const sumSizeByType = memoryUsageData.reduce((acc, current) => {
      const {
        type,
        size
      } = current;
      if (acc[type] === undefined) {
        acc[type] = size;
      } else {
        acc[type] = acc[type] + size;
      }
      return acc;
    }, {});
    const formattedSizes = [];
    Object.keys(sumSizeByType).forEach(type => {
      const size = sumSizeByType[type];
      formattedSizes.push({
        label: MEMORY_STATS_LABELS[type],
        value: bytesFormatter(size),
        'data-test-subj': `mlMemoryUsageStatsCount ${type}`
      });
    });
    setMemoryUsageStats(formattedSizes);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [memoryUsageLoading, memoryUsageError]);
  const tabs = (0, _react.useMemo)(() => [{
    id: TAB_IDS.OVERVIEW,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.overviewTabLabel",
      defaultMessage: "Overview",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 11
      }
    }),
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_collapsible_panel2.CollapsiblePanel, {
      dataTestSubj: "mlMemoryUsagePanel",
      isOpen: panelsExtendedState.memoryUsage,
      onToggle: update => {
        setPanelsExtendedState({
          ...panelsExtendedState,
          memoryUsage: update
        });
      },
      header: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.overview.memoryUsagePanel.header",
        defaultMessage: "Memory Usage",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 157,
          columnNumber: 19
        }
      }),
      headerItems: [/*#__PURE__*/_react.default.createElement(_collapsible_panel.OverviewStatsBar, {
        inputStats: memoryUsageStats,
        dataTestSub: 'mlOverviewMemoryUsageStatsBar',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 19
        }
      })],
      ariaLabel: _i18n.i18n.translate('xpack.ml.overview.memoryUsagePanel.ariaLabel', {
        defaultMessage: 'Memory usage panel'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_memory_page.MemoryPage, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 15
      }
    })), canViewMlNodes ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_collapsible_panel2.CollapsiblePanel, {
      dataTestSubj: "mlNodesPanel",
      isOpen: panelsState.nodes,
      onToggle: update => {
        setPanelsState({
          ...panelsState,
          nodes: update
        });
      },
      header: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.overview.nodesPanel.header",
        defaultMessage: "Nodes",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 21
        }
      }),
      headerItems: [/*#__PURE__*/_react.default.createElement(_collapsible_panel.OverviewStatsBar, {
        inputStats: [{
          label: _i18n.i18n.translate('xpack.ml.overview.nodesPanel.totalNodesLabel', {
            defaultMessage: 'Total'
          }),
          value: (0, _check_ml_nodes.getMlNodesCount)(),
          'data-test-subj': 'mlTotalNodesCount'
        }],
        dataTestSub: 'mlOverviewAnalyticsStatsBar',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 21
        }
      })],
      ariaLabel: _i18n.i18n.translate('xpack.ml.overview.nodesPanel.ariaLabel', {
        defaultMessage: 'Nodes panel'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_nodes_overview.NodesList, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 17
      }
    })) : null, /*#__PURE__*/_react.default.createElement(_content.OverviewContent, {
      createAnomalyDetectionJobDisabled: disableCreateAnomalyDetectionJob,
      setAdLazyJobCount: setAdLazyJobCount,
      setDfaLazyJobCount: setDfaLazyJobCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 13
      }
    }))
  }, {
    id: TAB_IDS.NOTIFICATIONS,
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.notificationsTabLabel",
      defaultMessage: "Notifications",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 11
      }
    }),
    append: errorsAndWarningCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.notificationsIndicator.unreadErrors', {
        defaultMessage: 'Unread errors or warnings indicator.'
      }),
      "data-test-subj": 'mlNotificationErrorsIndicator',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 11
      }
    }, errorsAndWarningCount) : undefined,
    content: /*#__PURE__*/_react.default.createElement(_notifications_list.NotificationsList, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 240,
        columnNumber: 18
      }
    })
  }], [canViewMlNodes, disableCreateAnomalyDetectionJob, errorsAndWarningCount, memoryUsageStats, panelsState, panelsExtendedState, setPanelsState, setPanelsExtendedState]);
  const renderTabs = () => {
    return tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
      key: tab.id,
      onClick: () => setSelectedTabId(tab.id),
      isSelected: tab.id === selectedTabId,
      "data-test-subj": `mlManagementOverviewPageTabs ${tab.id}`,
      append: tab.append,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 257,
        columnNumber: 7
      }
    }, tab.name));
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlStackManagementOverviewPage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: _i18n.i18n.translate('xpack.ml.management.machineLearningOverview.overviewLabel', {
      defaultMessage: 'Machine Learning Overview'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_node_available_warning.NodeAvailableWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_jobs_awaiting_node_warning.JobsAwaitingNodeWarning, {
    jobCount: adLazyJobCount + dfaLazyJobCount,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: () => {
      const {
        from,
        to
      } = timefilter.getTime();
      const timeRange = {
        start: from,
        end: to
      };
      _mlDatePicker.mlTimefilterRefresh$.next({
        lastRefresh: Date.now(),
        timeRange
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_upgrade.UpgradeWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 7
    }
  }, renderTabs()), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 7
    }
  }), (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content, /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 7
    }
  }));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.OverviewPage = OverviewPage;
var _default = exports.default = OverviewPage;