"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModelMemoryLimitInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _ml_server_info = require("../../../../../../services/ml_server_info");
var _job_creator_context = require("../../job_creator_context");
var _description = require("./description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/common/model_memory_limit/model_memory_limit_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ModelMemoryLimitInput = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobCreatorUpdated,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.modelMemoryLimit);
  const [modelMemoryLimit, setModelMemoryLimit] = (0, _react.useState)(jobCreator.modelMemoryLimit === null ? '' : jobCreator.modelMemoryLimit);
  const {
    anomaly_detectors: anomalyDetectors
  } = (0, _ml_server_info.getNewJobDefaults)();
  const {
    model_memory_limit: modelMemoryLimitDefault
  } = anomalyDetectors;
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'modelMemoryLimitInput'
  });
  (0, _react.useEffect)(() => {
    jobCreator.modelMemoryLimit = modelMemoryLimit === '' ? null : modelMemoryLimit;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [modelMemoryLimit]);
  (0, _react.useEffect)(() => {
    setModelMemoryLimit(jobCreator.modelMemoryLimit === null ? '' : jobCreator.modelMemoryLimit);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.modelMemoryLimit);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation,
    titleId: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: modelMemoryLimit,
    placeholder: modelMemoryLimitDefault,
    onChange: e => setModelMemoryLimit(e.target.value),
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardInputModelMemoryLimit",
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }));
};
exports.ModelMemoryLimitInput = ModelMemoryLimitInput;