"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobDetailsUI = exports.JobDetails = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _extract_job_details = require("./extract_job_details");
var _json_tab = require("./json_tab");
var _datafeed_preview_tab = require("./datafeed_preview_tab");
var _annotations_table = require("../../../../components/annotations/annotations_table");
var _datafeed_chart_flyout = require("../datafeed_chart_flyout");
var _annotation_flyout = require("../../../../components/annotations/annotation_flyout");
var _revert_model_snapshot_flyout = require("../../../../components/model_snapshots/revert_model_snapshot_flyout");
var _model_snapshots = require("../../../../components/model_snapshots");
var _forecasts_table = require("./forecasts_table");
var _job_details_pane = require("./job_details_pane");
var _job_messages_pane = require("./job_messages_pane");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/job_details/job_details.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class JobDetailsUI extends _react.Component {
  constructor(props) {
    super(props);
    this.state = {
      datafeedChartFlyoutVisible: false,
      modelSnapshot: null,
      revertSnapshotFlyoutVisible: false
    };
    if (this.props.addYourself) {
      this.props.addYourself(props.jobId, j => this.updateJob(j));
    }
  }
  componentWillUnmount() {
    this.props.removeYourself(this.props.jobId);
  }
  updateJob(job) {
    this.setState({
      job
    });
  }
  render() {
    var _this$state$job;
    const job = (_this$state$job = this.state.job) !== null && _this$state$job !== void 0 ? _this$state$job : this.props.job;
    const {
      services: {
        http: {
          basePath
        }
      }
    } = this.props.kibana;
    if (job === undefined) {
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "job-loading-spinner",
        "data-test-subj": "mlJobDetails loading",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 11
        }
      }));
    } else {
      const {
        refreshJobList,
        showClearButton
      } = this.props;
      const {
        general,
        customUrl,
        node,
        calendars,
        detectors,
        influencers,
        analysisConfig,
        analysisLimits,
        dataDescription,
        customSettings,
        jobTags,
        datafeed,
        counts,
        modelSizeStats,
        jobTimingStats,
        datafeedTimingStats,
        alertRules
      } = (0, _extract_job_details.extractJobDetails)(job, basePath, refreshJobList);
      if (job.blocked === undefined) {
        datafeed.titleAction = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          onClick: () => this.setState({
            datafeedChartFlyoutVisible: true
          }),
          iconType: "visAreaStacked",
          size: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 88,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.jobDetails.tabs.datafeed.viewCountsButtonText",
          defaultMessage: "View datafeed counts",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 13
          }
        }));
      }
      const tabs = [{
        id: 'job-settings',
        'data-test-subj': 'mlJobListTab-job-settings',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.jobSettingsLabel', {
          defaultMessage: 'Job settings'
        }),
        content: /*#__PURE__*/_react.default.createElement(_job_details_pane.JobDetailsPane, {
          "data-test-subj": "mlJobDetails-job-settings",
          sections: [general, customSettings, customUrl, jobTags, node, calendars, alertRules],
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 113,
            columnNumber: 13
          }
        }),
        time: job.open_time
      }, {
        id: 'job-config',
        'data-test-subj': 'mlJobListTab-job-config',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.jobConfigLabel', {
          defaultMessage: 'Job config'
        }),
        content: /*#__PURE__*/_react.default.createElement(_job_details_pane.JobDetailsPane, {
          "data-test-subj": "mlJobDetails-job-config",
          sections: [detectors, influencers, analysisConfig, analysisLimits, dataDescription],
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 127,
            columnNumber: 13
          }
        })
      }, {
        id: 'datafeed',
        'data-test-subj': 'mlJobListTab-datafeed',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.datafeedLabel', {
          defaultMessage: 'Datafeed'
        }),
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_job_details_pane.JobDetailsPane, {
          "data-test-subj": "mlJobDetails-datafeed",
          sections: [datafeed, datafeedTimingStats],
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 141,
            columnNumber: 15
          }
        }), this.props.jobId && this.state.datafeedChartFlyoutVisible ? /*#__PURE__*/_react.default.createElement(_datafeed_chart_flyout.DatafeedChartFlyout, {
          onClose: () => {
            this.setState({
              datafeedChartFlyoutVisible: false
            });
          },
          onModelSnapshotAnnotationClick: modelSnapshot => {
            this.setState({
              modelSnapshot,
              revertSnapshotFlyoutVisible: true,
              datafeedChartFlyoutVisible: false
            });
          },
          end: job.data_counts.latest_bucket_timestamp,
          jobId: this.props.jobId,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 146,
            columnNumber: 17
          }
        }) : null, this.state.revertSnapshotFlyoutVisible === true && this.state.modelSnapshot !== null ? /*#__PURE__*/_react.default.createElement(_revert_model_snapshot_flyout.RevertModelSnapshotFlyout, {
          snapshot: this.state.modelSnapshot,
          snapshots: [this.state.modelSnapshot],
          job: job,
          closeFlyout: () => {
            this.setState({
              revertSnapshotFlyoutVisible: false
            });
          },
          refresh: refreshJobList,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 165,
            columnNumber: 17
          }
        }) : null)
      }, ...(this.props.mode !== 'flyout' ? [{
        id: 'counts',
        'data-test-subj': 'mlJobListTab-counts',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.countsLabel', {
          defaultMessage: 'Counts'
        }),
        content: /*#__PURE__*/_react.default.createElement(_job_details_pane.JobDetailsPane, {
          "data-test-subj": "mlJobDetails-counts",
          sections: [counts, modelSizeStats, jobTimingStats],
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 189,
            columnNumber: 19
          }
        })
      }] : []), {
        id: 'json',
        'data-test-subj': 'mlJobListTab-json',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.jsonLabel', {
          defaultMessage: 'JSON'
        }),
        content: /*#__PURE__*/_react.default.createElement(_json_tab.JsonPane, {
          job: job,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 203,
            columnNumber: 20
          }
        })
      }, {
        id: 'job-messages',
        'data-test-subj': 'mlJobListTab-job-messages',
        name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.jobMessagesLabel', {
          defaultMessage: 'Job messages'
        }),
        content: /*#__PURE__*/_react.default.createElement(_job_messages_pane.JobMessagesPane, {
          jobId: job.job_id,
          refreshJobList: refreshJobList,
          showClearButton: showClearButton,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 212,
            columnNumber: 13
          }
        })
      }];
      if (this.props.mode !== 'flyout') {
        if (datafeed.items.length) {
          tabs.push({
            id: 'datafeed-preview',
            disabled: job.blocked !== undefined,
            'data-test-subj': 'mlJobListTab-datafeed-preview',
            name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.datafeedPreviewLabel', {
              defaultMessage: 'Datafeed preview'
            }),
            content: /*#__PURE__*/_react.default.createElement(_datafeed_preview_tab.DatafeedPreviewPane, {
              job: job,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 231,
                columnNumber: 24
              }
            })
          }, {
            id: 'forecasts',
            disabled: job.blocked !== undefined,
            'data-test-subj': 'mlJobListTab-forecasts',
            name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.forecastsLabel', {
              defaultMessage: 'Forecasts'
            }),
            content: /*#__PURE__*/_react.default.createElement(_forecasts_table.ForecastsTable, {
              job: job,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 240,
                columnNumber: 24
              }
            })
          });
        }
        tabs.push({
          id: 'annotations',
          disabled: job.blocked !== undefined,
          'data-test-subj': 'mlJobListTab-annotations',
          name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.annotationsLabel', {
            defaultMessage: 'Annotations'
          }),
          content: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 253,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_annotations_table.AnnotationsTable, {
            jobs: [job],
            refreshJobList: refreshJobList,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 254,
              columnNumber: 15
            }
          }), /*#__PURE__*/_react.default.createElement(_annotation_flyout.AnnotationFlyout, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 255,
              columnNumber: 15
            }
          }))
        });
        tabs.push({
          id: 'modelSnapshots',
          disabled: job.blocked !== undefined,
          'data-test-subj': 'mlJobListTab-modelSnapshots',
          name: _i18n.i18n.translate('xpack.ml.jobsList.jobDetails.tabs.modelSnapshotsLabel', {
            defaultMessage: 'Model snapshots'
          }),
          content: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 268,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_model_snapshots.ModelSnapshotTable, {
            job: job,
            refreshJobList: refreshJobList,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 269,
              columnNumber: 15
            }
          }))
        });
      }
      return /*#__PURE__*/_react.default.createElement("div", {
        className: "tab-contents",
        "data-test-subj": `mlJobListRowDetails details-${job.job_id}`,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
        tabs: tabs,
        initialSelectedTab: tabs[0],
        onTabClick: () => {},
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 276,
          columnNumber: 11
        }
      }));
    }
  }
}
exports.JobDetailsUI = JobDetailsUI;
JobDetailsUI.propTypes = {
  jobId: _propTypes.default.string.isRequired,
  job: _propTypes.default.object,
  addYourself: _propTypes.default.func.isRequired,
  removeYourself: _propTypes.default.func.isRequired,
  refreshJobList: _propTypes.default.func
};
const JobDetails = exports.JobDetails = (0, _public.withKibana)(JobDetailsUI);