"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewEditor = DataViewEditor;
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_table_settings = require("../../data_frame_analytics/pages/analytics_management/components/analytics_list/use_table_settings");
var _data_drift_index_patterns_editor = require("./data_drift_index_patterns_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/datavisualizer/data_drift/data_view_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const mustMatchError = _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.createIndex.noMatch', {
  defaultMessage: 'Name must match one or more data streams, indices, or index aliases.'
});
function DataViewEditor({
  id,
  label,
  dataViewEditorService,
  indexPattern,
  setIndexPattern,
  onError,
  helpText
}) {
  (0, _useDebounce.default)(() => {
    dataViewEditorService.setIndexPattern(indexPattern);
  }, 250, [indexPattern]);
  const matchedIndices = (0, _useObservable.default)(dataViewEditorService.matchedIndices$, _data_drift_index_patterns_editor.matchedIndicesDefault);
  const matchedReferenceIndices = indexPattern === '' || indexPattern !== '' && matchedIndices.exactMatchedIndices.length === 0 ? matchedIndices.allIndices : matchedIndices.exactMatchedIndices;
  const [appendedWildcard, setAppendedWildcard] = (0, _react.useState)(false);
  const [pageState, updatePageState] = (0, _react.useState)({
    pageIndex: 0,
    pageSize: 10,
    sortField: 'name',
    sortDirection: 'asc'
  });
  const {
    onTableChange,
    pagination
  } = (0, _use_table_settings.useTableSettings)(matchedReferenceIndices.length, pageState, updatePageState);
  const pageOfItems = (0, _react.useMemo)(() => {
    return matchedReferenceIndices.slice(pagination.pageIndex * pagination.pageSize, (pagination.pageIndex + 1) * pagination.pageSize);
  }, [pagination.pageSize, pagination.pageIndex, matchedReferenceIndices]);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.tableColShard', {
      defaultMessage: 'Matched indices'
    }),
    sortable: false,
    truncateText: false
  }];
  const errorMessage = (0, _react.useMemo)(() => {
    if (indexPattern === '') return _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.error.noEmptyIndexPattern', {
      defaultMessage: 'Index pattern must not be empty.'
    });
    if (indexPattern !== '' && matchedIndices.exactMatchedIndices.length === 0) {
      return mustMatchError;
    }
    return undefined;
  }, [indexPattern, matchedIndices.exactMatchedIndices.length]);
  (0, _react.useEffect)(() => {
    if (onError) {
      onError(errorMessage);
    }
  }, [onError, errorMessage]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      paddingLeft: euiTheme.size.base,
      paddingRight: euiTheme.size.base,
      borderRight: euiTheme.border.thin
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    error: errorMessage,
    isInvalid: errorMessage !== undefined,
    fullWidth: true,
    helpText: helpText,
    "data-test-subj": `mlDataDriftIndexPatternFormRow-${id !== null && id !== void 0 ? id : ''}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: errorMessage !== undefined,
    value: indexPattern,
    onChange: e => {
      let query = e.target.value;
      if (query.length === 1 && !appendedWildcard && (0, _data_drift_index_patterns_editor.canAppendWildcard)(query)) {
        query += '*';
        setAppendedWildcard(true);
        setTimeout(() => e.target.setSelectionRange(1, 1));
      } else {
        if (['', '*'].includes(query) && appendedWildcard) {
          query = '';
          setAppendedWildcard(false);
        }
      }
      setIndexPattern(query);
    },
    fullWidth: true,
    "data-test-subj": `mlDataDriftIndexPatternTitleInput-${id !== null && id !== void 0 ? id : ''}`,
    placeholder: "example-pattern*",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      paddingLeft: euiTheme.size.base,
      paddingRight: euiTheme.size.base
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, errorMessage === mustMatchError ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataDrift.indexPatternsEditor.notMatchDetail",
    defaultMessage: "The index pattern you entered doesn't match any data streams, indices, or index aliases. You can match {strongIndices}.",
    values: {
      strongIndices: /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataDrift.indexPatternsEditor.allIndicesLabel",
        defaultMessage: "{indicesLength, plural, one {# source} other {# sources} }",
        values: {
          indicesLength: matchedIndices.allIndices.length
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 21
        }
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: pageOfItems,
    columns: columns,
    pagination: pagination,
    onChange: onTableChange,
    "data-test-subject": `mlDataDriftIndexPatternTable-${id !== null && id !== void 0 ? id : ''}`,
    rowProps: item => {
      return {
        'data-test-subj': `mlDataDriftIndexPatternTableRow row-${id}`
      };
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  })));
}