"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.viewActionButtonText = exports.ViewButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _get_view_link_status = require("./get_view_link_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/action_view/view_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const viewActionButtonText = exports.viewActionButtonText = _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.viewActionName', {
  defaultMessage: 'View'
});
const ViewButton = ({
  item
}) => {
  const {
    disabled,
    tooltipContent
  } = (0, _get_view_link_status.getViewLinkStatus)(item);
  if (disabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: tooltipContent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 9
      }
    }, viewActionButtonText));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, viewActionButtonText);
};
exports.ViewButton = ViewButton;