"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLSavedObjectsSpacesList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _saved_objects = require("../../../../common/types/saved_objects");
var _kibana = require("../../contexts/kibana");
var _toast_notification_service = require("../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/ml_saved_objects_spaces_list/ml_saved_objects_spaces_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ALL_SPACES_ID = '*';
const jobObjectNoun = _i18n.i18n.translate('xpack.ml.management.jobsSpacesList.jobObjectNoun', {
  defaultMessage: 'job'
});
const modelObjectNoun = _i18n.i18n.translate('xpack.ml.management.jobsSpacesList.modelObjectNoun', {
  defaultMessage: 'trained model'
});
const FALLBACK_SPACES_ID = [];
const MLSavedObjectsSpacesList = ({
  spacesApi,
  spaceIds = FALLBACK_SPACES_ID,
  id,
  mlSavedObjectType,
  refresh,
  disabled = false
}) => {
  const {
    savedObjects: {
      updateJobsSpaces,
      updateModelsSpaces
    }
  } = (0, _kibana.useMlApi)();
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  async function changeSpacesHandler(_objects,
  // this is ignored because ML jobs do not have references
  spacesToAdd, spacesToMaybeRemove) {
    // If the user is adding the job to all current and future spaces, don't remove it from any specified spaces
    const spacesToRemove = spacesToAdd.includes(ALL_SPACES_ID) ? [] : spacesToMaybeRemove;
    if (spacesToAdd.length || spacesToRemove.length) {
      if (mlSavedObjectType === 'trained-model') {
        const resp = await updateModelsSpaces([id], spacesToAdd, spacesToRemove);
        handleApplySpaces(resp);
      } else {
        const resp = await updateJobsSpaces(mlSavedObjectType, [id], spacesToAdd, spacesToRemove);
        handleApplySpaces(resp);
      }
    }
    onClose();
  }
  function onClose() {
    setShowFlyout(false);
    refresh();
  }
  function handleApplySpaces(resp) {
    Object.entries(resp).forEach(([errorId, {
      success,
      error
    }]) => {
      if (success === false) {
        const title = _i18n.i18n.translate('xpack.ml.management.jobsSpacesList.updateSpaces.error', {
          defaultMessage: 'Error updating {id}',
          values: {
            id: errorId
          }
        });
        displayErrorToast(error, title);
      }
    });
  }

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const LazySpaceList = (0, _react.useCallback)(spacesApi.ui.components.getSpaceList, [spacesApi]);
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const LazyShareToSpaceFlyout = (0, _react.useCallback)(spacesApi.ui.components.getShareToSpaceFlyout, [spacesApi]);
  const shareToSpaceFlyoutProps = {
    savedObjectTarget: {
      type: _saved_objects.ML_JOB_SAVED_OBJECT_TYPE,
      id,
      namespaces: spaceIds,
      title: id,
      noun: mlSavedObjectType === 'trained-model' ? modelObjectNoun : jobObjectNoun
    },
    behaviorContext: 'outside-space',
    changeSpacesHandler,
    onClose
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: disabled,
    onClick: () => setShowFlyout(true),
    style: {
      height: 'auto'
    },
    "data-test-subj": "mlJobListRowManageSpacesButton",
    "aria-label": _i18n.i18n.translate('xpack.ml.management.jobsSpacesList.manageSpacesButtonAriaLabel', {
      defaultMessage: 'Manage spaces for this {mlSavedObjectType}',
      values: {
        mlSavedObjectType
      }
    }),
    tabIndex: spaceIds.length > 0 ? 0 : -1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(LazySpaceList, {
    namespaces: spaceIds,
    displayLimit: 0,
    behaviorContext: "outside-space",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 9
    }
  })), showFlyout && /*#__PURE__*/_react.default.createElement(LazyShareToSpaceFlyout, (0, _extends2.default)({}, shareToSpaceFlyoutProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 22
    }
  })));
};
exports.MLSavedObjectsSpacesList = MLSavedObjectsSpacesList;