"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _kibana = require("../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/ml_page/date_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DatePicker = () => {
  const {
    services: {
      mlServices: {
        httpService
      }
    }
  } = (0, _kibana.useMlKibana)();
  (0, _react.useEffect)(() => {
    const subscriptions = new _rxjs.Subscription();
    subscriptions.add(httpService.getLoadingCount$.pipe((0, _rxjs.map)(v => v !== 0), (0, _rxjs.distinctUntilChanged)()).subscribe(loading => {
      setIsLoading(loading);
    }));
    return function cleanup() {
      subscriptions.unsubscribe();
    };
  }, [httpService === null || httpService === void 0 ? void 0 : httpService.getLoadingCount$]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerWrapper, {
    isLoading: isLoading,
    width: "full",
    dataTestSubj: "mlDatePickerRefreshPageButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  });
};
exports.DatePicker = DatePicker;