"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExperiencePlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serverRouteRepository = require("@kbn/server-route-repository");
var _rxjs = require("rxjs");
var _routes = require("./routes");
var _set_esql_recommended_queries = require("./lib/esql_extensions/set_esql_recommended_queries");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class MetricsExperiencePlugin {
  constructor(initContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "metricExperienceEnabled$", void 0);
    (0, _defineProperty2.default)(this, "pluginStop$", void 0);
    this.logger = initContext.logger.get();
    this.pluginStop$ = new _rxjs.ReplaySubject(1);
  }
  setup(core, plugins) {
    void core.getStartServices().then(([coreStart]) => {
      (0, _serverRouteRepository.registerRoutes)({
        core,
        logger: this.logger,
        repository: _routes.routeRepository,
        dependencies: {
          pluginsSetup: {
            ...plugins,
            core
          }
        },
        runDevModeChecks: true
      });
      this.metricExperienceEnabled$ = coreStart.featureFlags.getBooleanValue$(_constants.METRICS_EXPERIENCE_FEATURE_FLAG_KEY, true).pipe((0, _rxjs.takeUntil)(this.pluginStop$)).subscribe(isMetricsExperienceEnabled => {
        if (isMetricsExperienceEnabled) {
          (0, _set_esql_recommended_queries.setEsqlRecommendedQueries)(plugins.esql);
        }
      });
    });
  }
  start(_core) {}
  stop() {
    this.pluginStop$.next();
    this.pluginStop$.complete();
    if (this.metricExperienceEnabled$ !== undefined) {
      this.metricExperienceEnabled$.unsubscribe();
    }
  }
}
exports.MetricsExperiencePlugin = MetricsExperiencePlugin;