"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureEditTools = void 0;
var _reactRedux = require("react-redux");
var _feature_edit_tools = require("./feature_edit_tools");
var _actions = require("../../../../actions");
var _map_selectors = require("../../../../selectors/map_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  const editState = (0, _map_selectors.getEditState)(state);
  return {
    drawShape: editState ? editState.drawShape : undefined
  };
}
function mapDispatchToProps(dispatch) {
  return {
    setDrawShape: shapeToDraw => {
      dispatch((0, _actions.updateEditShape)(shapeToDraw));
    }
  };
}
const connectedFeatureEditControl = exports.FeatureEditTools = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_feature_edit_tools.FeatureEditTools);