"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INCOMPLETE_RESULTS_WARNING = exports.AbstractLayer = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _searchResponseWarnings = require("@kbn/search-response-warnings");
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uuid = require("uuid");
var _data_request = require("../util/data_request");
var _tile_meta_feature_utils = require("../util/tile_meta_feature_utils");
var _constants = require("../../../common/constants");
var _copy_persistent_state = require("../../reducers/copy_persistent_state");
var _es_source = require("../sources/es_source");
var _tile_errors_list = require("./tile_errors_list");
var _layer_group = require("./layer_group");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/layer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable @typescript-eslint/consistent-type-definitions */
const INCOMPLETE_RESULTS_WARNING = exports.INCOMPLETE_RESULTS_WARNING = _i18n.i18n.translate('xpack.maps.layer.incompleteResultsWarning', {
  defaultMessage: `Layer had issues returning data and results might be incomplete.`
});
class AbstractLayer {
  static createDescriptor(options) {
    return {
      ...options,
      sourceDescriptor: options.sourceDescriptor ? options.sourceDescriptor : null,
      __dataRequests: _lodash.default.get(options, '__dataRequests', []),
      id: _lodash.default.get(options, 'id', (0, _uuid.v4)()),
      label: options.label && options.label.length > 0 ? options.label : undefined,
      minZoom: _lodash.default.get(options, 'minZoom', _constants.MIN_ZOOM),
      maxZoom: _lodash.default.get(options, 'maxZoom', _constants.MAX_ZOOM),
      alpha: _lodash.default.get(options, 'alpha', 0.75),
      visible: _lodash.default.get(options, 'visible', true),
      style: _lodash.default.get(options, 'style', null),
      includeInFitToBounds: typeof options.includeInFitToBounds === 'boolean' ? options.includeInFitToBounds : true
    };
  }
  constructor({
    layerDescriptor,
    source
  }) {
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    (0, _defineProperty2.default)(this, "_source", void 0);
    (0, _defineProperty2.default)(this, "_dataRequests", void 0);
    this._descriptor = AbstractLayer.createDescriptor(layerDescriptor);
    this._source = source;
    if (this._descriptor.__dataRequests) {
      this._dataRequests = this._descriptor.__dataRequests.map(dataRequest => new _data_request.DataRequest(dataRequest));
    } else {
      this._dataRequests = [];
    }
  }
  static getBoundDataForSource(mbMap, sourceId) {
    // @ts-expect-error
    const mbStyle = mbMap.getStyle();
    return mbStyle.sources[sourceId].data;
  }
  getDescriptor() {
    return this._descriptor;
  }
  async cloneDescriptor() {
    const clonedDescriptor = (0, _copy_persistent_state.copyPersistentState)(this._descriptor);
    // layer id is uuid used to track styles/layers in mapbox
    clonedDescriptor.id = (0, _uuid.v4)();
    const displayName = await this.getDisplayName();
    clonedDescriptor.label = `Clone of ${displayName}`;
    clonedDescriptor.sourceDescriptor = this.getSource().cloneDescriptor();
    return [clonedDescriptor];
  }
  makeMbLayerId(layerNameSuffix) {
    return `${this.getId()}${_constants.MB_SOURCE_ID_LAYER_ID_PREFIX_DELIMITER}${layerNameSuffix}`;
  }
  isPreviewLayer() {
    return !!this._descriptor.__isPreviewLayer;
  }
  async supportsFitToBounds() {
    return await this.getSource().supportsFitToBounds();
  }
  async isFittable() {
    return (await this.supportsFitToBounds()) && this.isVisible() && this.isIncludeInFitToBounds();
  }
  isIncludeInFitToBounds() {
    return !!this._descriptor.includeInFitToBounds;
  }
  async isFilteredByGlobalTime() {
    return false;
  }
  async getDisplayName(source) {
    if (this._descriptor.label) {
      return this._descriptor.label;
    }
    const sourceDisplayName = source ? await source.getDisplayName() : await this.getSource().getDisplayName();
    return sourceDisplayName || this._descriptor.id;
  }
  async getAttributions() {
    if (this.hasErrors() || !this.isVisible()) {
      return [];
    }
    const attributionProvider = this.getSource().getAttributionProvider();
    if (attributionProvider) {
      return attributionProvider();
    }
    return this._descriptor.attribution !== undefined ? [this._descriptor.attribution] : [];
  }
  getStyleForEditing() {
    throw new Error('Should implement AbstractLayer#getStyleForEditing');
  }
  getStyle() {
    throw new Error('Should implement AbstractLayer#getStyle');
  }
  getCurrentStyle() {
    throw new Error('Should implement AbstractLayer#getCurrentStyle');
  }
  getLabel() {
    return this._descriptor.label ? this._descriptor.label : '';
  }
  getLocale() {
    return null;
  }
  getLayerIcon(isTocIcon) {
    return {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: this.getLayerTypeIconName(),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 287,
          columnNumber: 13
        }
      })
    };
  }
  async hasLegendDetails() {
    return false;
  }
  renderLegendDetails() {
    return null;
  }
  getId() {
    return this._descriptor.id;
  }
  getSource() {
    return this._source;
  }
  getSourceForEditing() {
    return this._source;
  }
  isVisible() {
    return !!this._descriptor.visible;
  }
  showAtZoomLevel(zoom) {
    return zoom >= this.getMinZoom() && zoom <= this.getMaxZoom();
  }
  getMinZoom() {
    return typeof this._descriptor.minZoom === 'number' ? this._descriptor.minZoom : _constants.MIN_ZOOM;
  }
  getMaxZoom() {
    return typeof this._descriptor.maxZoom === 'number' ? this._descriptor.maxZoom : _constants.MAX_ZOOM;
  }
  getMinSourceZoom() {
    return this._source.getMinZoom();
  }
  getMbSourceId() {
    return this.getId();
  }
  _requiresPrevSourceCleanup(mbMap) {
    return false;
  }
  _removeStaleMbSourcesAndLayers(mbMap) {
    if (this._requiresPrevSourceCleanup(mbMap)) {
      // @ts-expect-error
      const mbStyle = mbMap.getStyle();
      // @ts-expect-error
      mbStyle.layers.forEach(mbLayer => {
        if (this.ownsMbLayerId(mbLayer.id)) {
          // @ts-expect-error
          mbMap.removeLayer(mbLayer.id);
        }
      });
      Object.keys(mbStyle.sources).some(mbSourceId => {
        if (this.ownsMbSourceId(mbSourceId)) {
          // @ts-expect-error
          mbMap.removeSource(mbSourceId);
        }
      });
    }
  }
  getAlpha() {
    return typeof this._descriptor.alpha === 'number' ? this._descriptor.alpha : 1;
  }
  getQuery() {
    return this._descriptor.query ? this._descriptor.query : null;
  }
  renderSourceSettingsEditor(sourceEditorArgs) {
    return this.getSourceForEditing().renderSourceSettingsEditor(sourceEditorArgs);
  }
  getPrevRequestToken(dataId) {
    const prevDataRequest = this.getDataRequest(dataId);
    if (!prevDataRequest) {
      return;
    }
    return prevDataRequest.getRequestToken();
  }
  getInFlightRequestTokens() {
    if (!this._dataRequests) {
      return [];
    }
    const requestTokens = this._dataRequests.map(dataRequest => dataRequest.getRequestToken());

    // Compact removes all the undefineds
    return _lodash.default.compact(requestTokens);
  }
  getSourceDataRequest() {
    return this.getDataRequest(_constants.SOURCE_DATA_REQUEST_ID);
  }
  getDataRequest(id) {
    return this._dataRequests.find(dataRequest => dataRequest.getDataId() === id);
  }
  isLayerLoading(zoom) {
    if (!this.isVisible() || !this.showAtZoomLevel(zoom)) {
      return false;
    }
    const hasOpenDataRequests = this._dataRequests.some(dataRequest => dataRequest.isLoading());
    if (this._isTiled()) {
      return hasOpenDataRequests || this._descriptor.__areTilesLoaded === undefined || !this._descriptor.__areTilesLoaded;
    }
    return !this.getSourceDataRequest() ? true // layer is loading until source data request has been created
    : hasOpenDataRequests;
  }
  hasErrors() {
    const inspectorAdapters = {}; // errors are not interacted with so empty Adapters can be passed to getErrors
    return this.getErrors(inspectorAdapters).length > 0;
  }
  _getSourceErrorTitle() {
    return _i18n.i18n.translate('xpack.maps.layer.sourceErrorTitle', {
      defaultMessage: `An error occurred when loading layer data`
    });
  }
  getErrors(inspectorAdapters) {
    var _this$getSourceDataRe, _this$_descriptor$__t;
    const errors = [];
    const sourceError = (_this$getSourceDataRe = this.getSourceDataRequest()) === null || _this$getSourceDataRe === void 0 ? void 0 : _this$getSourceDataRe.renderError();
    if (sourceError) {
      errors.push({
        title: this._getSourceErrorTitle(),
        body: sourceError
      });
    }
    if ((_this$_descriptor$__t = this._descriptor.__tileErrors) !== null && _this$_descriptor$__t !== void 0 && _this$_descriptor$__t.length) {
      errors.push({
        title: _i18n.i18n.translate('xpack.maps.layer.tileErrorTitle', {
          defaultMessage: `An error occurred when loading layer tiles`
        }),
        body: /*#__PURE__*/_react.default.createElement(_tile_errors_list.TileErrorsList, {
          inspectorAdapters: inspectorAdapters,
          isESVectorTileSource: !(0, _layer_group.isLayerGroup)(this) && (0, _es_source.isESVectorTileSource)(this.getSource()),
          layerId: this.getId(),
          tileErrors: this._descriptor.__tileErrors,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 446,
            columnNumber: 11
          }
        })
      });
    }
    return errors;
  }
  hasWarnings() {
    const hasDataRequestWarnings = this._dataRequests.some(dataRequest => {
      var _dataRequestMeta$warn;
      const dataRequestMeta = dataRequest.getMeta();
      return dataRequestMeta === null || dataRequestMeta === void 0 ? void 0 : (_dataRequestMeta$warn = dataRequestMeta.warnings) === null || _dataRequestMeta$warn === void 0 ? void 0 : _dataRequestMeta$warn.length;
    });
    if (hasDataRequestWarnings) {
      return true;
    }
    return this._isTiled() ? this._getTileMetaFeatures().some(_tile_meta_feature_utils.hasIncompleteResults) : false;
  }
  getWarnings() {
    const warningMessages = [];
    const dataRequestWarnings = [];
    this._dataRequests.forEach(dataRequest => {
      var _dataRequestMeta$warn2;
      const dataRequestMeta = dataRequest.getMeta();
      if (dataRequestMeta !== null && dataRequestMeta !== void 0 && (_dataRequestMeta$warn2 = dataRequestMeta.warnings) !== null && _dataRequestMeta$warn2 !== void 0 && _dataRequestMeta$warn2.length) {
        dataRequestWarnings.push(...dataRequestMeta.warnings);
      }
    });
    if (dataRequestWarnings.length) {
      warningMessages.push({
        title: (0, _searchResponseWarnings.getWarningsTitle)(dataRequestWarnings),
        body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, INCOMPLETE_RESULTS_WARNING, ' ', /*#__PURE__*/_react.default.createElement(_searchResponseWarnings.ViewDetailsPopover, {
          displayAsLink: true,
          warnings: dataRequestWarnings,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 489,
            columnNumber: 13
          }
        }))
      });
    }
    if (this._isTiled() && this._getTileMetaFeatures().some(_tile_meta_feature_utils.hasIncompleteResults)) {
      warningMessages.push({
        title: '',
        body: INCOMPLETE_RESULTS_WARNING
      });
    }
    return warningMessages;
  }
  async syncData(syncContext) {
    // no-op by default
  }
  getMbLayerIds() {
    throw new Error('Should implement AbstractLayer#getMbLayerIds');
  }
  ownsMbLayerId(layerId) {
    throw new Error('Should implement AbstractLayer#ownsMbLayerId');
  }
  ownsMbSourceId(mbSourceId) {
    throw new Error('Should implement AbstractLayer#ownsMbSourceId');
  }
  syncLayerWithMB(mbMap) {
    throw new Error('Should implement AbstractLayer#syncLayerWithMB');
  }
  getLayerTypeIconName() {
    throw new Error('should implement Layer#getLayerTypeIconName');
  }
  async getBounds(getDataRequestContext) {
    return null;
  }
  renderStyleEditor(onStyleDescriptorChange, onCustomIconsChange) {
    const style = this.getStyleForEditing();
    if (!style) {
      return null;
    }
    return style.renderEditor(onStyleDescriptorChange, onCustomIconsChange);
  }
  getIndexPatternIds() {
    return [];
  }
  getQueryableIndexPatternIds() {
    return [];
  }
  syncVisibilityWithMb(mbMap, mbLayerId) {
    // @ts-expect-error
    mbMap.setLayoutProperty(mbLayerId, 'visibility', this.isVisible() ? 'visible' : 'none');
  }
  getType() {
    return this._descriptor.type;
  }
  areLabelsOnTop() {
    return false;
  }
  supportsLabelsOnTop() {
    return false;
  }
  supportsLabelLocales() {
    return false;
  }
  async getLicensedFeatures() {
    return [];
  }
  getGeoFieldNames() {
    const source = this.getSource();
    const geoFieldName = (0, _es_source.hasESSourceMethod)(source, 'getGeoFieldName') ? source.getGeoFieldName() : undefined;
    return geoFieldName ? [geoFieldName] : [];
  }
  async getStyleMetaDescriptorFromLocalFeatures() {
    return null;
  }
  isBasemap(order) {
    return false;
  }
  getParent() {
    return this._descriptor.parent;
  }
  _getTileMetaFeatures() {
    var _this$_descriptor$__t2;
    return (_this$_descriptor$__t2 = this._descriptor.__tileMetaFeatures) !== null && _this$_descriptor$__t2 !== void 0 ? _this$_descriptor$__t2 : [];
  }
  _isTiled() {
    throw new Error('Must implement AbstractLayer#_isTiled');
  }
}
exports.AbstractLayer = AbstractLayer;