"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esAggFieldsFactory = esAggFieldsFactory;
var _constants = require("../../../../common/constants");
var _es_doc_field = require("../es_doc_field");
var _top_term_percentage_field = require("./top_term_percentage_field");
var _count_agg_field = require("./count_agg_field");
var _agg_field = require("./agg_field");
var _percentile_agg_field = require("./percentile_agg_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function esAggFieldsFactory(aggDescriptor, source, origin) {
  let aggField;
  if (aggDescriptor.type === _constants.AGG_TYPE.COUNT) {
    aggField = new _count_agg_field.CountAggField({
      label: aggDescriptor.label,
      source,
      origin,
      mask: aggDescriptor.mask
    });
  } else if (aggDescriptor.type === _constants.AGG_TYPE.PERCENTILE) {
    aggField = new _percentile_agg_field.PercentileAggField({
      label: aggDescriptor.label,
      esDocField: 'field' in aggDescriptor && aggDescriptor.field ? new _es_doc_field.ESDocField({
        fieldName: aggDescriptor.field,
        source,
        origin
      }) : undefined,
      percentile: 'percentile' in aggDescriptor && typeof aggDescriptor.percentile === 'number' ? aggDescriptor.percentile : _constants.DEFAULT_PERCENTILE,
      source,
      origin,
      mask: aggDescriptor.mask
    });
  } else {
    aggField = new _agg_field.AggField({
      label: aggDescriptor.label,
      esDocField: 'field' in aggDescriptor && aggDescriptor.field ? new _es_doc_field.ESDocField({
        fieldName: aggDescriptor.field,
        source,
        origin
      }) : undefined,
      aggType: aggDescriptor.type,
      source,
      origin,
      mask: aggDescriptor.mask
    });
  }
  const aggFields = [aggField];
  if ('field' in aggDescriptor && aggDescriptor.type === _constants.AGG_TYPE.TERMS) {
    aggFields.push(new _top_term_percentage_field.TopTermPercentageField(aggField));
  }
  return aggFields;
}