"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformLayersOut = transformLayersOut;
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformLayersOut(layers) {
  return layers.map(layer => {
    if ('sourceDescriptor' in layer && layer.sourceDescriptor) {
      const source = layer.sourceDescriptor;
      if (source.type === _constants.SOURCE_TYPES.ESQL) {
        const {
          columns,
          dataViewId,
          ...restOfSource
        } = source;
        layer.sourceDescriptor = restOfSource;
      }
    }
    return layer;
  });
}