"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensSavedObjectSchema = exports.lensItemSchema = exports.lensItemDataSchema = exports.lensItemAttributesSchema = exports.lensCommonSavedObjectSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _utils = require("../../../utils");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const lensItemAttributesSchema = exports.lensItemAttributesSchema = _configSchema.schema.object({
  title: _configSchema.schema.string(),
  description: _configSchema.schema.maybe(_configSchema.schema.string()),
  visualizationType: _configSchema.schema.string(),
  state: _configSchema.schema.maybe(_configSchema.schema.any()),
  // TODO make version required
  version: _configSchema.schema.maybe(_configSchema.schema.literal(_constants.LENS_ITEM_VERSION)) // pin version explicitly
}, {
  unknowns: 'forbid'
});

/**
 * The underlying SO type used to store Lens state in Content Management.
 *
 * Only used in lens server-side Content Management.
 */
const lensSavedObjectSchema = exports.lensSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(lensItemAttributesSchema);

/**
 * The Lens item data returned from the server
 */
const lensItemSchema = exports.lensItemSchema = _configSchema.schema.object({
  ...(0, _utils.pickFromObjectSchema)(lensSavedObjectSchema.getPropSchemas(), ['id', 'references']),
  ...lensSavedObjectSchema.getPropSchemas().attributes.getPropSchemas()
}, {
  unknowns: 'forbid'
});

/**
 * The common SO type used for mSearch items.
 */
const lensCommonSavedObjectSchema = exports.lensCommonSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(_configSchema.schema.object({
  ...(0, _utils.pickFromObjectSchema)(lensItemAttributesSchema.getPropSchemas(), ['title', 'description'])
}, {
  unknowns: 'forbid'
}));

// TODO: cleanup data for update, should we forbid or just ignore body.id on update?
const lensItemDataSchema = exports.lensItemDataSchema = lensItemSchema.extends({
  id: undefined
});