"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uniqueCountMetricOperationSchema = exports.sumMetricOperationSchema = exports.staticOperationDefinitionSchema = exports.percentileRanksOperationSchema = exports.percentileOperationSchema = exports.movingAverageOperationSchema = exports.metricOperationSharedSchema = exports.metricOperationSchema = exports.metricOperationDefinitionSchema = exports.lastValueOperationSchema = exports.genericOperationOptionsSchema = exports.formulaOperationDefinitionSchema = exports.fieldMetricOperationsSchema = exports.fieldBasedOperationSharedSchema = exports.esqlColumnSchema = exports.differencesOperationSchema = exports.cumulativeSumOperationSchema = exports.counterRateOperationSchema = exports.countMetricOperationSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _filter = require("./filter");
var _format = require("./format");
var _constants = require("./constants");
var _utils = require("../transforms/columns/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const genericOperationOptionsSchema = exports.genericOperationOptionsSchema = {
  ..._format.formatSchema,
  /**
   * Label for the operation
   */
  label: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Label for the operation'
    }
  }))
};
const staticOperationDefinitionSchema = exports.staticOperationDefinitionSchema = _configSchema.schema.object({
  ...genericOperationOptionsSchema,
  operation: _configSchema.schema.literal('static_value'),
  /**
   * Static value
   */
  value: _configSchema.schema.number({
    meta: {
      description: 'Static value'
    },
    defaultValue: _constants.LENS_STATIC_VALUE_DEFAULT
  })
});
const formulaOperationDefinitionSchema = exports.formulaOperationDefinitionSchema = _configSchema.schema.object({
  ...genericOperationOptionsSchema,
  operation: _configSchema.schema.literal('formula'),
  /**
   * Formula
   */
  formula: _configSchema.schema.string({
    meta: {
      description: 'Formula'
    }
  }),
  /**
   * Filter
   */
  filter: _configSchema.schema.maybe(_filter.filterSchema),
  /**
   * Reduced time range
   */
  reduced_time_range: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Reduced time range'
    }
  }))
});
const esqlColumnSchema = exports.esqlColumnSchema = _configSchema.schema.object({
  /**
   * Value
   */
  operation: _configSchema.schema.literal('value'),
  column: _configSchema.schema.string({
    meta: {
      description: 'Column to use'
    }
  })
});
const metricOperationSharedSchema = exports.metricOperationSharedSchema = {
  ...genericOperationOptionsSchema,
  /**
   * Time scale
   */
  time_scale: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('s'), _configSchema.schema.literal('m'), _configSchema.schema.literal('h'), _configSchema.schema.literal('d')], {
    meta: {
      description: 'Time scale'
    }
  })),
  /**
   * Reduced time range
   */
  reduced_time_range: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Reduced time range'
    }
  })),
  /**
   * Time shift
   */
  time_shift: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Time shift'
    }
  })),
  /**
   * Filter
   */
  filter: _configSchema.schema.maybe(_filter.filterSchema)
};
const fieldBasedOperationSharedSchema = exports.fieldBasedOperationSharedSchema = {
  ...metricOperationSharedSchema,
  /**
   * Field to be used for the metric
   */
  field: _configSchema.schema.string({
    meta: {
      description: 'Field to be used for the metric'
    }
  })
};
const emptyAsNullSchemaRawObject = {
  /**
   * Whether to consider null values as null
   */
  empty_as_null: _configSchema.schema.boolean({
    meta: {
      description: 'Whether to consider null values as null'
    },
    defaultValue: _utils.LENS_EMPTY_AS_NULL_DEFAULT_VALUE
  })
};
const countMetricOperationSchema = exports.countMetricOperationSchema = _configSchema.schema.object({
  ...fieldBasedOperationSharedSchema,
  ...emptyAsNullSchemaRawObject,
  /**
   * Select the operation type
   */
  operation: _configSchema.schema.literal('count'),
  /**
   * Field to be used for the metric
   */
  field: _configSchema.schema.maybe(_configSchema.schema.string())
});
const uniqueCountMetricOperationSchema = exports.uniqueCountMetricOperationSchema = _configSchema.schema.object({
  ...fieldBasedOperationSharedSchema,
  ...emptyAsNullSchemaRawObject,
  operation: _configSchema.schema.literal('unique_count')
});
const metricOperationSchema = exports.metricOperationSchema = _configSchema.schema.object({
  ...fieldBasedOperationSharedSchema,
  operation: _configSchema.schema.oneOf([_configSchema.schema.literal('min'), _configSchema.schema.literal('max'), _configSchema.schema.literal('average'), _configSchema.schema.literal('median'), _configSchema.schema.literal('standard_deviation')])
});
const sumMetricOperationSchema = exports.sumMetricOperationSchema = _configSchema.schema.object({
  ...fieldBasedOperationSharedSchema,
  ...emptyAsNullSchemaRawObject,
  operation: _configSchema.schema.literal('sum')
});
const lastValueOperationSchema = exports.lastValueOperationSchema = _configSchema.schema.object({
  ...fieldBasedOperationSharedSchema,
  operation: _configSchema.schema.literal('last_value'),
  sort_by: _configSchema.schema.string(),
  show_array_values: _configSchema.schema.boolean({
    meta: {
      description: 'Handle array values'
    },
    defaultValue: _constants.LENS_LAST_VALUE_DEFAULT_SHOW_ARRAY_VALUES
  })
});
const percentileOperationSchema = exports.percentileOperationSchema = _configSchema.schema.object({
  ...fieldBasedOperationSharedSchema,
  operation: _configSchema.schema.literal('percentile'),
  percentile: _configSchema.schema.number({
    meta: {
      description: 'Percentile'
    },
    defaultValue: _constants.LENS_PERCENTILE_DEFAULT_VALUE
  })
});
const percentileRanksOperationSchema = exports.percentileRanksOperationSchema = _configSchema.schema.object({
  ...fieldBasedOperationSharedSchema,
  operation: _configSchema.schema.literal('percentile_rank'),
  rank: _configSchema.schema.number({
    meta: {
      description: 'Percentile Rank'
    },
    defaultValue: _constants.LENS_PERCENTILE_RANK_DEFAULT_VALUE
  })
});
const fieldMetricOperationsSchema = exports.fieldMetricOperationsSchema = _configSchema.schema.oneOf([countMetricOperationSchema, uniqueCountMetricOperationSchema, metricOperationSchema, sumMetricOperationSchema, lastValueOperationSchema, percentileOperationSchema, percentileRanksOperationSchema]);
const differencesOperationSchema = exports.differencesOperationSchema = _configSchema.schema.object({
  ...metricOperationSharedSchema,
  operation: _configSchema.schema.literal('differences'),
  of: fieldMetricOperationsSchema
});
const movingAverageOperationSchema = exports.movingAverageOperationSchema = _configSchema.schema.object({
  ...metricOperationSharedSchema,
  operation: _configSchema.schema.literal('moving_average'),
  of: fieldMetricOperationsSchema,
  window: _configSchema.schema.number({
    meta: {
      description: 'Window'
    },
    defaultValue: _constants.LENS_MOVING_AVERAGE_DEFAULT_WINDOW
  })
});
const cumulativeSumOperationSchema = exports.cumulativeSumOperationSchema = _configSchema.schema.object({
  ...fieldBasedOperationSharedSchema,
  operation: _configSchema.schema.literal('cumulative_sum')
});
const counterRateOperationSchema = exports.counterRateOperationSchema = _configSchema.schema.object({
  ...fieldBasedOperationSharedSchema,
  operation: _configSchema.schema.literal('counter_rate')
});
const metricOperationDefinitionSchema = exports.metricOperationDefinitionSchema = _configSchema.schema.oneOf([formulaOperationDefinitionSchema, staticOperationDefinitionSchema, fieldMetricOperationsSchema, differencesOperationSchema, movingAverageOperationSchema, cumulativeSumOperationSchema, counterRateOperationSchema, countMetricOperationSchema, uniqueCountMetricOperationSchema, lastValueOperationSchema, percentileOperationSchema, percentileRanksOperationSchema]);