"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tagcloudStateSchemaNoESQL = exports.tagcloudStateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _metric_ops = require("../metric_ops");
var _color = require("../color");
var _dataset = require("../dataset");
var _shared = require("../shared");
var _shared2 = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const tagcloudStateMetricOptionsSchema = _configSchema.schema.object({
  /**
   * Whether to show the metric label
   */
  show_metric_label: _configSchema.schema.boolean({
    meta: {
      description: 'Show metric label'
    },
    defaultValue: false
  })
});
const tagcloudStateTagsByOptionsSchema = _configSchema.schema.object({
  /**
   * Color configuration
   */
  color: _configSchema.schema.maybe(_color.colorMappingSchema)
});
const tagcloudStateSharedOptionsSchema = {
  /**
   * Orientation of the tagcloud:
   * - 'horizontal': Horizontal orientation (default)
   * - 'vertical': Vertical orientation
   * - 'right_angled': Right angled orientation
   **/
  orientation: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('horizontal'), _configSchema.schema.literal('vertical'), _configSchema.schema.literal('right_angled')], {
    defaultValue: 'horizontal'
  })),
  /**
   * Font size configuration:
   * - 'min': Minimum font size (default: 14)
   * - 'max': Maximum font size (default: 72)
   **/
  font_size: _configSchema.schema.maybe(_configSchema.schema.object({
    min: _configSchema.schema.number({
      defaultValue: 14,
      min: 1
    }),
    max: _configSchema.schema.number({
      defaultValue: 72,
      max: 120
    })
  }))
};
const tagcloudStateSchemaNoESQL = exports.tagcloudStateSchemaNoESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('tagcloud'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.dslOnlyPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetSchema,
  ...tagcloudStateSharedOptionsSchema,
  /**
   * Primary value configuration, must define operation.
   */
  metric: (0, _shared2.mergeAllMetricsWithChartDimensionSchema)(tagcloudStateMetricOptionsSchema),
  /**
   * Configure how to break down to tags
   */
  tag_by: _configSchema.schema.maybe((0, _shared2.mergeAllBucketsWithChartDimensionSchema)(tagcloudStateTagsByOptionsSchema))
});
const tagcloudStateSchemaESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('tagcloud'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetEsqlTableSchema,
  ...tagcloudStateSharedOptionsSchema,
  /**
   * Primary value configuration, must define operation.
   */
  metric: _configSchema.schema.allOf([_configSchema.schema.object(_metric_ops.genericOperationOptionsSchema), tagcloudStateMetricOptionsSchema, _metric_ops.esqlColumnSchema]),
  /**
   * Configure how to break down the metric (e.g. show one metric per term).
   */
  tag_by: _configSchema.schema.maybe(_configSchema.schema.allOf([tagcloudStateTagsByOptionsSchema, _metric_ops.esqlColumnSchema]))
});
const tagcloudStateSchema = exports.tagcloudStateSchema = _configSchema.schema.oneOf([tagcloudStateSchemaNoESQL, tagcloudStateSchemaESQL]);