"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricStateSchemaNoESQL = exports.metricStateSchema = exports.esqlMetricState = exports.complementaryVizSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _metric_ops = require("../metric_ops");
var _color = require("../color");
var _dataset = require("../dataset");
var _shared = require("../shared");
var _shared2 = require("./shared");
var _alignments = require("../alignments");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const compareToSchemaShared = _configSchema.schema.object({
  palette: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Palette'
    }
  })),
  icon: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Show icon'
    },
    defaultValue: true
  })),
  value: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'Show value'
    },
    defaultValue: true
  }))
});
const complementaryVizSchema = exports.complementaryVizSchema = _configSchema.schema.oneOf([_configSchema.schema.object({
  type: _configSchema.schema.literal('bar'),
  /**
   * Direction of the bar. Possible values:
   * - 'vertical': Bar is oriented vertically
   * - 'horizontal': Bar is oriented horizontally
   */
  direction: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('vertical'), _configSchema.schema.literal('horizontal')])),
  /**
   * Goal value
   */
  goal_value: _metric_ops.metricOperationDefinitionSchema
}), _configSchema.schema.object({
  type: _configSchema.schema.literal('trend')
})]);
const metricStatePrimaryMetricOptionsSchema = _configSchema.schema.object({
  /**
   * Sub label
   */
  sub_label: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Sub label'
    }
  })),
  /**
   * Alignments of the labels and values for the primary metric.
   * For example, align the labels to the left and the values to the right.
   */
  alignments: _configSchema.schema.object({
    /**
     * Alignments for labels. Possible values:
     * - 'left': Align label to the left
     * - 'center': Align label to the center
     * - 'right': Align label to the right
     */
    labels: (0, _alignments.horizontalAlignmentSchema)({
      meta: {
        description: 'Alignments for labels'
      },
      defaultValue: 'left'
    }),
    /**
     * Alignments for value. Possible values:
     * - 'left': Align value to the left
     * - 'center': Align value to the center
     * - 'right': Align value to the right
     */
    value: (0, _alignments.horizontalAlignmentSchema)({
      meta: {
        description: 'Alignments for value'
      },
      defaultValue: 'left'
    })
  }, {
    defaultValue: {
      labels: 'left',
      value: 'left'
    }
  }),
  /**
   * Whether to fit the value
   */
  fit: _configSchema.schema.boolean({
    meta: {
      description: 'Whether to fit the value'
    },
    defaultValue: false
  }),
  /**
   * Icon configuration
   */
  icon: _configSchema.schema.maybe(_configSchema.schema.object({
    /**
     * Icon name
     */
    name: _configSchema.schema.string({
      meta: {
        description: 'Icon name'
      }
    }),
    /**
     * Icon alignment. Possible values:
     * - 'right': Icon is aligned to the right
     * - 'left': Icon is aligned to the left
     */
    align: (0, _alignments.leftRightAlignmentSchema)({
      meta: {
        description: 'Icon alignment'
      },
      defaultValue: 'right'
    })
  })),
  /**
   * Color configuration
   */
  color: _configSchema.schema.maybe(_configSchema.schema.oneOf([_color.colorByValueAbsolute, _color.staticColorSchema])),
  /**
   * Where to apply the color (background or value)
   */
  apply_color_to: _configSchema.schema.maybe(_color.applyColorToSchema),
  /**
   * Complementary visualization
   */
  background_chart: _configSchema.schema.maybe(complementaryVizSchema)
});
const metricStateSecondaryMetricOptionsSchema = _configSchema.schema.object({
  /**
   * Prefix
   */
  prefix: _configSchema.schema.maybe(_configSchema.schema.string({
    meta: {
      description: 'Prefix'
    }
  })),
  /**
   * Compare to
   */
  compare: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.allOf([compareToSchemaShared, _configSchema.schema.object({
    to: _configSchema.schema.literal('baseline'),
    baseline: _configSchema.schema.number({
      meta: {
        description: 'Baseline value'
      },
      defaultValue: 0
    })
  })]), _configSchema.schema.allOf([compareToSchemaShared, _configSchema.schema.object({
    to: _configSchema.schema.literal('primary')
  })])])),
  /**
   * Color configuration
   */
  color: _configSchema.schema.maybe(_configSchema.schema.oneOf([_color.colorByValueAbsolute, _color.staticColorSchema]))
});
const metricStateBreakdownByOptionsSchema = _configSchema.schema.object({
  /**
   * Number of columns
   */
  columns: _configSchema.schema.number({
    defaultValue: 5,
    meta: {
      description: 'Number of columns'
    }
  }),
  /**
   * Collapse by function. This parameter is used to collapse the
   * metric chart when the number of columns is bigger than the
   * number of columns specified in the columns parameter.
   * Possible values:
   * - 'avg': Collapse by average
   * - 'sum': Collapse by sum
   * - 'max': Collapse by max
   * - 'min': Collapse by min
   * - 'none': Do not collapse
   */
  collapse_by: _configSchema.schema.maybe(_shared.collapseBySchema)
});
const metricStateSchemaNoESQL = exports.metricStateSchemaNoESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('metric'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.dslOnlyPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetSchema,
  /**
   * Primary value configuration, must define operation.
   */
  metric: (0, _shared2.mergeAllMetricsWithChartDimensionSchemaWithRefBasedOps)(metricStatePrimaryMetricOptionsSchema),
  /**
   * Secondary value configuration, must define operation.
   */
  secondary_metric: _configSchema.schema.maybe((0, _shared2.mergeAllMetricsWithChartDimensionSchemaWithRefBasedOps)(metricStateSecondaryMetricOptionsSchema)),
  /**
   * Configure how to break down the metric (e.g. show one metric per term).
   */
  breakdown_by: _configSchema.schema.maybe((0, _shared2.mergeAllBucketsWithChartDimensionSchema)(metricStateBreakdownByOptionsSchema))
});
const esqlMetricState = exports.esqlMetricState = _configSchema.schema.object({
  type: _configSchema.schema.literal('metric'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetEsqlTableSchema,
  /**
   * Primary value configuration, must define operation.
   */
  metric: _configSchema.schema.allOf([_configSchema.schema.object(_metric_ops.genericOperationOptionsSchema), metricStatePrimaryMetricOptionsSchema, _metric_ops.esqlColumnSchema]),
  /**
   * Secondary value configuration, must define operation.
   */
  secondary_metric: _configSchema.schema.maybe(_configSchema.schema.allOf([_configSchema.schema.object(_metric_ops.genericOperationOptionsSchema), metricStateSecondaryMetricOptionsSchema, _metric_ops.esqlColumnSchema])),
  /**
   * Configure how to break down the metric (e.g. show one metric per term).
   */
  breakdown_by: _configSchema.schema.maybe(_configSchema.schema.allOf([metricStateBreakdownByOptionsSchema, _metric_ops.esqlColumnSchema]))
});
const metricStateSchema = exports.metricStateSchema = _configSchema.schema.oneOf([metricStateSchemaNoESQL, esqlMetricState]);