"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyMetricStateSchemaNoESQL = exports.legacyMetricStateSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _metric_ops = require("../metric_ops");
var _dataset = require("../dataset");
var _shared = require("../shared");
var _color = require("../color");
var _alignments = require("../alignments");
var _shared2 = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const legacyMetricStateMetricOptionsSchema = _configSchema.schema.object({
  /**
   * Size of the legacy metric label and value. Possible values:
   * - 'xs': Extra small
   * - 's': Small
   * - 'm': Medium (default)
   * - 'l': Large
   * - 'xl': Extra large
   * - 'xxl': Double extra large
   */
  size: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('xs'), _configSchema.schema.literal('s'), _configSchema.schema.literal('m'), _configSchema.schema.literal('l'), _configSchema.schema.literal('xl'), _configSchema.schema.literal('xxl')], {
    meta: {
      description: 'Font size for the label and value'
    },
    defaultValue: 'm'
  })),
  /**
   * Alignment of the label and value for the legacy metric.
   * For example, align the label to the bottom and the value to the right.
   */
  alignments: _configSchema.schema.maybe(_configSchema.schema.object({
    /**
     * Alignment for label. Possible values:
     * - 'top': Align label to the top of the value (default)
     * - 'bottom': Align label to the bottom of the value
     */
    labels: (0, _alignments.verticalAlignmentSchema)({
      meta: {
        description: 'Label alignment'
      },
      defaultValue: 'top'
    }),
    /**
     * Alignment for value. Possible values:
     * - 'left': Align value to the left (default)
     * - 'center': Align value to the center
     * - 'right': Align value to the right
     */
    value: (0, _alignments.horizontalAlignmentSchema)({
      meta: {
        description: 'Value alignment'
      },
      defaultValue: 'left'
    })
  })),
  /**
   * Where to apply the color (background or value)
   */
  apply_color_to: _configSchema.schema.maybe(_color.applyColorToSchema),
  /**
   * Color configuration
   */
  color: _configSchema.schema.maybe(_color.colorByValueAbsolute)
});
const legacyMetricStateSchemaNoESQL = exports.legacyMetricStateSchemaNoESQL = _configSchema.schema.object({
  type: _configSchema.schema.literal('legacy_metric'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.dslOnlyPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetSchema,
  /**
   * Metric configuration, must define operation.
   */
  metric: (0, _shared2.mergeAllMetricsWithChartDimensionSchema)(legacyMetricStateMetricOptionsSchema)
});
const esqlLegacyMetricState = _configSchema.schema.object({
  type: _configSchema.schema.literal('legacy_metric'),
  ..._shared.sharedPanelInfoSchema,
  ..._shared.layerSettingsSchema,
  ..._dataset.datasetEsqlTableSchema,
  /**
   * Metric configuration, must define operation.
   */
  metric: _configSchema.schema.allOf([_configSchema.schema.object(_metric_ops.genericOperationOptionsSchema), legacyMetricStateMetricOptionsSchema, _metric_ops.esqlColumnSchema])
});
const legacyMetricStateSchema = exports.legacyMetricStateSchema = _configSchema.schema.oneOf([legacyMetricStateSchemaNoESQL, esqlLegacyMetricState]);