"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildHeatmap = buildHeatmap;
var _types = require("../types");
var _utils = require("../utils");
var _columns = require("../columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACCESSOR = 'metric_formula_accessor';
function getAccessorName(type) {
  return `${type}_${ACCESSOR}`;
}
function buildVisualizationState(config) {
  var _config$legend, _config$legend2;
  const layer = config;
  return {
    layerId: _types.DEFAULT_LAYER_ID,
    layerType: 'data',
    shape: 'heatmap',
    valueAccessor: ACCESSOR,
    ...(layer.xAxis ? {
      xAccessor: getAccessorName('x')
    } : {}),
    ...(layer.breakdown ? {
      yAccessor: getAccessorName('y')
    } : {}),
    gridConfig: {
      type: 'heatmap_grid',
      isCellLabelVisible: false,
      isXAxisLabelVisible: false,
      isXAxisTitleVisible: false,
      isYAxisLabelVisible: false,
      isYAxisTitleVisible: false
    },
    legend: {
      isVisible: ((_config$legend = config.legend) === null || _config$legend === void 0 ? void 0 : _config$legend.show) || true,
      position: ((_config$legend2 = config.legend) === null || _config$legend2 === void 0 ? void 0 : _config$legend2.position) || 'left',
      type: 'heatmap_legend'
    }
  };
}
function buildFormulaLayer(layer, i, dataView) {
  const defaultLayer = {
    ...(0, _columns.getFormulaColumn)(ACCESSOR, (0, _utils.mapToFormula)(layer), dataView)
  };
  if (layer.xAxis) {
    const columnName = getAccessorName('x');
    const breakdownColumn = (0, _columns.getBreakdownColumn)({
      options: layer.xAxis,
      dataView
    });
    (0, _utils.addLayerColumn)(defaultLayer, columnName, breakdownColumn, true);
  }
  if (layer.breakdown) {
    const columnName = getAccessorName('y');
    const breakdownColumn = (0, _columns.getBreakdownColumn)({
      options: layer.breakdown,
      dataView
    });
    (0, _utils.addLayerColumn)(defaultLayer, columnName, breakdownColumn, true);
  }
  return defaultLayer;
}
function getValueColumns(layer) {
  if (layer.breakdown && typeof layer.breakdown !== 'string') {
    throw new Error('breakdown must be a field name when not using index source');
  }
  if (typeof layer.xAxis !== 'string') {
    throw new Error('xAxis must be a field name when not using index source');
  }
  return [...(layer.breakdown ? [(0, _columns.getValueColumn)(getAccessorName('y'), layer.breakdown)] : []), (0, _columns.getValueColumn)(getAccessorName('x'), layer.xAxis), (0, _columns.getValueColumn)(ACCESSOR, layer.value)];
}
async function buildHeatmap(config, {
  dataViewsAPI
}) {
  const dataviews = {};
  const _buildFormulaLayer = (cfg, i, dataView) => buildFormulaLayer(cfg, i, dataView);
  const datasourceStates = await (0, _utils.buildDatasourceStates)(config, dataviews, _buildFormulaLayer, getValueColumns, dataViewsAPI);
  const {
    references,
    internalReferences,
    adHocDataViews
  } = (0, _utils.extractReferences)(dataviews);
  return {
    title: config.title,
    visualizationType: 'lnsHeatmap',
    references,
    state: {
      datasourceStates,
      internalReferences,
      filters: [],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization: buildVisualizationState(config),
      adHocDataViews
    }
  };
}