"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResetDocumentsModal = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/test_pipeline/test_pipeline_tabs/tab_documents/reset_documents_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  modalTitle: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.resetDocumentsModal.title', {
    defaultMessage: 'Clear documents'
  }),
  modalDescription: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.resetDocumentsModal.description', {
    defaultMessage: 'This will reset the output.'
  }),
  cancelButtonLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.resetDocumentsModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  resetButtonLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.testPipeline.resetDocumentsModal.resetButtonLabel', {
    defaultMessage: 'Clear documents'
  })
};
const ResetDocumentsModal = ({
  confirmResetTestOutput,
  closeModal
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    buttonColor: "danger",
    "data-test-subj": "resetDocumentsConfirmationModal",
    title: i18nTexts.modalTitle,
    titleProps: {
      id: modalTitleId
    },
    onCancel: closeModal,
    onConfirm: confirmResetTestOutput,
    cancelButtonText: i18nTexts.cancelButtonLabel,
    confirmButtonText: i18nTexts.resetButtonLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, i18nTexts.modalDescription));
};
exports.ResetDocumentsModal = ResetDocumentsModal;