"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaffleSortControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _dropdown_button = require("../dropdown_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/waffle_sort_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LABELS = {
  name: _i18n.i18n.translate('xpack.infra.waffle.sortNameLabel', {
    defaultMessage: 'Name'
  }),
  value: _i18n.i18n.translate('xpack.infra.waffle.sort.valueLabel', {
    defaultMessage: 'Metric value'
  })
};
const WaffleSortControls = ({
  sort,
  onChange
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsOpen(currentIsOpen => !currentIsOpen), []);
  const closePopover = (0, _react.useCallback)(() => setIsOpen(false), []);
  const label = LABELS[sort.by];
  const button = /*#__PURE__*/_react.default.createElement(_dropdown_button.DropdownButton, {
    label: _i18n.i18n.translate('xpack.infra.waffle.sortLabel', {
      defaultMessage: 'Sort by'
    }),
    onClick: togglePopover,
    "data-test-subj": 'waffleSortByDropdown',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, label);
  const selectName = (0, _react.useCallback)(() => {
    onChange({
      ...sort,
      by: 'name'
    });
    closePopover();
  }, [closePopover, onChange, sort]);
  const selectValue = (0, _react.useCallback)(() => {
    onChange({
      ...sort,
      by: 'value'
    });
    closePopover();
  }, [closePopover, onChange, sort]);
  const toggleSort = (0, _react.useCallback)(() => {
    onChange({
      ...sort,
      direction: sort.direction === 'asc' ? 'desc' : 'asc'
    });
    closePopover();
  }, [closePopover, sort, onChange]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    title: '',
    items: [{
      name: LABELS.name,
      icon: sort.by === 'name' ? 'check' : 'empty',
      onClick: selectName,
      'data-test-subj': 'waffleSortByName'
    }, {
      name: LABELS.value,
      icon: sort.by === 'value' ? 'check' : 'empty',
      onClick: selectValue,
      'data-test-subj': 'waffleSortByValue'
    }]
  }], [sort.by, selectName, selectValue]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isOpen,
    id: "sortPopover",
    button: button,
    anchorPosition: "downLeft",
    panelPaddingSize: "none",
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(SwitchContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: _i18n.i18n.translate('xpack.infra.waffle.sortDirectionLabel', {
      defaultMessage: 'Reverse direction'
    }),
    checked: sort.direction === 'desc',
    onChange: toggleSort,
    "data-test-subj": 'waffleSortByDirection',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  })));
};
exports.WaffleSortControls = WaffleSortControls;
const SwitchContainer = (0, _eui.withEuiTheme)(({
  children,
  theme
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: theme === null || theme === void 0 ? void 0 : theme.euiTheme.size.m,
      borderTop: `${theme === null || theme === void 0 ? void 0 : theme.euiTheme.border.thin}`
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, children);
});