"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReadOnlyBadge = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useReadOnlyBadge = (isReadOnly = false) => {
  const chrome = (0, _public.useKibana)().services.chrome;
  (0, _react.useEffect)(() => {
    chrome === null || chrome === void 0 ? void 0 : chrome.setBadge(isReadOnly ? {
      text: _i18n.i18n.translate('xpack.infra.header.badge.readOnly.text', {
        defaultMessage: 'Read only'
      }),
      tooltip: _i18n.i18n.translate('xpack.infra.header.badge.readOnly.tooltip', {
        defaultMessage: 'Unable to change source configuration'
      }),
      iconType: 'glasses'
    } : undefined);
  }, [chrome, isReadOnly]);
  return null;
};
exports.useReadOnlyBadge = useReadOnlyBadge;