"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _formatters = require("../../../../../common/formatters");
var _process_row = require("./process_row");
var _processes_empty_message = require("./processes_empty_message");
var _state_badge = require("./state_badge");
var _states = require("./states");
var _metric_not_available_explanation = require("../../components/metric_not_available_explanation");
var _translations = require("../../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/processes/processes_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useSortableProperties(sortablePropertyItems, defaultSortProperty, callback) {
  const [sortableProperties] = (0, _react.useState)(new _eui.SortableProperties(sortablePropertyItems, defaultSortProperty));
  return {
    updateSortableProperties: (0, _react.useCallback)(property => {
      sortableProperties.sortOn(property);
      callback((0, _lodash.omit)(sortableProperties.getSortedProperty(), 'getValue'));
    }, [sortableProperties, callback])
  };
}
const ProcessesTable = ({
  processList,
  currentTime,
  isLoading,
  sortBy,
  error,
  setSortBy,
  clearSearchBar,
  schema
}) => {
  const {
    updateSortableProperties
  } = useSortableProperties([{
    name: 'startTime',
    getValue: item => Date.parse(item.startTime),
    isAscending: true
  }, {
    name: 'cpu',
    getValue: item => item.cpu,
    isAscending: false
  }, {
    name: 'memory',
    getValue: item => item.memory,
    isAscending: false
  }], 'cpu', setSortBy);
  const currentItems = (0, _react.useMemo)(() => processList.sort((a, b) => _states.STATE_ORDER.indexOf(a.state) - _states.STATE_ORDER.indexOf(b.state)), [processList]);
  const hideStateColumn = schema === 'semconv';
  const visibleColumns = (0, _react.useMemo)(() => hideStateColumn ? columns.filter(col => col.field !== 'state') : columns, [hideStateColumn]);
  if (!isLoading && currentItems.length === 0) return /*#__PURE__*/_react.default.createElement(_processes_empty_message.ProcessesEmptyMessage, {
    schema: schema,
    clearSearchBar: clearSearchBar,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 12
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    "data-test-subj": "infraAssetDetailsProcessesTable",
    responsiveBreakpoint: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    width: 24,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), visibleColumns.map(column => {
    var _column$align;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
      key: `${String(column.field)}-header`,
      align: (_column$align = column.align) !== null && _column$align !== void 0 ? _column$align : _eui.LEFT_ALIGNMENT,
      width: column.width,
      onSort: column.sortable ? () => updateSortableProperties(column.field) : undefined,
      isSorted: sortBy.name === column.field,
      isSortAscending: sortBy.name === column.field && sortBy.isAscending,
      "data-test-subj": `${String(column.field)}-header`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 11
      }
    }, column.name);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
    css: (0, _react2.css)`
          position: relative;
          & .euiTableCellContent {
            padding-top: 0;
            padding-bottom: 0;
          }
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 7
    }
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 15
    }
  }))), isLoading && currentItems.length === 0 && !error && /*#__PURE__*/_react.default.createElement(ProcessesTableMessage, {
    visibleColumnsCount: visibleColumns.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.processes.loading",
    defaultMessage: "Loading...",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 13
    }
  })), error ? /*#__PURE__*/_react.default.createElement(ProcessesTableMessage, {
    visibleColumnsCount: visibleColumns.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minusInCircle",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }), " ", error) : /*#__PURE__*/_react.default.createElement(ProcessesTableBody, {
    items: currentItems,
    currentTime: currentTime,
    visibleColumns: visibleColumns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  })));
};
exports.ProcessesTable = ProcessesTable;
const ProcessesTableMessage = ({
  children,
  visibleColumnsCount
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    "data-test-subj": "infraAssetDetailsProcessesSearchInputError",
    style: {
      paddingTop: `${euiTheme.size.s}`,
      paddingBottom: `${euiTheme.size.s}`
    },
    align: "center",
    colSpan: visibleColumnsCount + 1,
    mobileOptions: {
      width: '100%'
    },
    textOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }, children));
};
const ProcessesTableBody = ({
  items,
  currentTime,
  visibleColumns
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map((item, i) => {
  const cells = visibleColumns.map(column => {
    var _column$align2, _column$textOnly;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      key: `${String(column.field)}-${i}`,
      mobileOptions: {
        header: column.name
      },
      align: (_column$align2 = column.align) !== null && _column$align2 !== void 0 ? _column$align2 : _eui.LEFT_ALIGNMENT,
      textOnly: (_column$textOnly = column.textOnly) !== null && _column$textOnly !== void 0 ? _column$textOnly : true,
      truncateText: column.truncateText,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 9
      }
    }, column.render ? column.render(item[column.field], currentTime) : item[column.field]);
  });
  return /*#__PURE__*/_react.default.createElement(_process_row.ProcessRow, {
    cells: cells,
    item: item,
    key: `row-${i}`,
    supportAIAssistant: true,
    visibleColumnsCount: visibleColumns.length,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 9
    }
  });
}));
const ONE_MINUTE = 60 * 1000;
const ONE_HOUR = ONE_MINUTE * 60;
const RuntimeCell = ({
  startTime,
  currentTime
}) => {
  const runtimeLength = currentTime - startTime;
  let remainingRuntimeMS = runtimeLength;
  const runtimeHours = Math.floor(remainingRuntimeMS / ONE_HOUR);
  remainingRuntimeMS -= runtimeHours * ONE_HOUR;
  const runtimeMinutes = Math.floor(remainingRuntimeMS / ONE_MINUTE);
  remainingRuntimeMS -= runtimeMinutes * ONE_MINUTE;
  const runtimeSeconds = Math.floor(remainingRuntimeMS / 1000);
  remainingRuntimeMS -= runtimeSeconds * 1000;
  const runtimeDisplayHours = runtimeHours ? `${runtimeHours}:` : '';
  const runtimeDisplayMinutes = runtimeMinutes < 10 ? `0${runtimeMinutes}:` : `${runtimeMinutes}:`;
  const runtimeDisplaySeconds = runtimeSeconds < 10 ? `0${runtimeSeconds}` : runtimeSeconds;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${runtimeDisplayHours}${runtimeDisplayMinutes}${runtimeDisplaySeconds}`);
};
const columnLabelCPU = _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.columnLabelCPU', {
  defaultMessage: 'CPU'
});
const columns = [{
  field: 'state',
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.columnLabelState', {
    defaultMessage: 'State'
  }),
  sortable: false,
  render: state => /*#__PURE__*/_react.default.createElement(_state_badge.StateBadge, {
    state: state,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 32
    }
  }),
  width: 84,
  textOnly: false
}, {
  field: 'command',
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.columnLabelCommand', {
    defaultMessage: 'Command'
  }),
  sortable: false,
  width: '40%',
  truncateText: true,
  render: command => /*#__PURE__*/_react.default.createElement(CodeLine, {
    command: command,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 34
    }
  })
}, {
  field: 'startTime',
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.columnLabelTime', {
    defaultMessage: 'Time'
  }),
  align: _eui.RIGHT_ALIGNMENT,
  sortable: true,
  render: (startTime, currentTime) => /*#__PURE__*/_react.default.createElement(RuntimeCell, {
    startTime: startTime,
    currentTime: currentTime,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 7
    }
  })
}, {
  field: 'cpu',
  name: columnLabelCPU,
  sortable: true,
  render: value => value === null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 11
    }
  }, _translations.NOT_AVAILABLE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_not_available_explanation.MetricNotAvailableExplanationTooltip, {
    metricName: columnLabelCPU,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 13
    }
  }))) : _formatters.FORMATTERS.percent(value)
}, {
  field: 'memory',
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.columnLabelMemory', {
    defaultMessage: 'Mem.'
  }),
  sortable: true,
  render: value => value === null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 11
    }
  }, _translations.NOT_AVAILABLE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_metric_not_available_explanation.MetricNotAvailableExplanationTooltip, {
    metricName: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.memory', {
      defaultMessage: 'memory'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 13
    }
  }))) : _formatters.FORMATTERS.percent(value)
}];
const CodeLine = ({
  command
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        white-space: pre;
        overflow: hidden;
        text-overflow: ellipsis;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    transparentBackground: true,
    css: (0, _react2.css)`
          color: ${euiTheme.colors.textParagraph};
          font-weight: ${euiTheme.font.weight.medium};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 7
    }
  }, command));
};