"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertAnnotation = AlertAnnotation;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/log_threshold/components/alert_details_app_section/components/alert_annotation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AlertAnnotation({
  alertStarted
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    uiSettings
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  return /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "annotation_alert_started",
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: [{
      dataValue: alertStarted,
      header: (0, _moment.default)(alertStarted).format(uiSettings.get(_public.UI_SETTINGS.DATE_FORMAT)),
      details: _i18n.i18n.translate('xpack.infra.logs.alertDetails.chartAnnotation.alertStarted', {
        defaultMessage: 'Alert started'
      })
    }],
    style: {
      line: {
        strokeWidth: 3,
        stroke: euiTheme.colors.borderStrongDanger,
        opacity: 1
      }
    },
    marker: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "danger",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 15
      }
    }),
    markerPosition: _charts.Position.Top,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 21,
      columnNumber: 5
    }
  });
}