"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tokenCountChunkToLangchain = exports.completionChunkToLangchain = void 0;
var _messages = require("@langchain/core/messages");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// type is not exported from @langchain/core...
// import { ToolCallChunk } from '@langchain/core/messages/tools';

const completionChunkToLangchain = chunk => {
  const toolCallChunks = chunk.tool_calls.map(toolCall => {
    return {
      index: toolCall.index,
      id: toolCall.toolCallId || undefined,
      name: toolCall.function.name || undefined,
      args: toolCall.function.arguments || undefined,
      type: 'tool_call_chunk'
    };
  });
  return new _messages.AIMessageChunk({
    content: chunk.content,
    tool_call_chunks: toolCallChunks,
    additional_kwargs: {},
    response_metadata: {}
  });
};
exports.completionChunkToLangchain = completionChunkToLangchain;
const tokenCountChunkToLangchain = chunk => {
  return new _messages.AIMessageChunk({
    content: '',
    response_metadata: {
      usage: {
        ...chunk.tokens
      }
    },
    usage_metadata: {
      input_tokens: chunk.tokens.prompt,
      output_tokens: chunk.tokens.completion,
      total_tokens: chunk.tokens.total
    }
  });
};
exports.tokenCountChunkToLangchain = tokenCountChunkToLangchain;