"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceFieldSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _app_context = require("../../../../../app_context");
var _documentation = require("../../../../../services/documentation");
var _shared_imports = require("../../../shared_imports");
var _i18n_texts = require("./i18n_texts");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/configuration_form/source_field_section/source_field_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SourceFieldSection = () => {
  const {
    canUseSyntheticSource
  } = (0, _app_context.useAppContext)();
  const renderOptionDropdownDisplay = option => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }, _i18n_texts.sourceOptionLabels[option]), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 9
    }
  }, _i18n_texts.sourceOptionDescriptions[option])));
  const sourceValueOptions = [{
    value: _constants.STORED_SOURCE_OPTION,
    inputDisplay: _i18n_texts.sourceOptionLabels[_constants.STORED_SOURCE_OPTION],
    dropdownDisplay: renderOptionDropdownDisplay(_constants.STORED_SOURCE_OPTION),
    'data-test-subj': 'storedSourceFieldOption'
  }];
  if (canUseSyntheticSource) {
    sourceValueOptions.push({
      value: _constants.SYNTHETIC_SOURCE_OPTION,
      inputDisplay: _i18n_texts.sourceOptionLabels[_constants.SYNTHETIC_SOURCE_OPTION],
      dropdownDisplay: renderOptionDropdownDisplay(_constants.SYNTHETIC_SOURCE_OPTION),
      'data-test-subj': 'syntheticSourceFieldOption'
    });
  }
  sourceValueOptions.push({
    value: _constants.DISABLED_SOURCE_OPTION,
    inputDisplay: _i18n_texts.sourceOptionLabels[_constants.DISABLED_SOURCE_OPTION],
    dropdownDisplay: renderOptionDropdownDisplay(_constants.DISABLED_SOURCE_OPTION),
    'data-test-subj': 'disabledSourceFieldOption'
  });
  const renderDisableWarning = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutTitle', {
      defaultMessage: 'Use caution when disabling the _source field'
    }),
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutDescription1",
    defaultMessage: "Disabling {source} is not recommended. If storage overhead is a concern, consider using synthetic {source} instead. Disabling {source} will disable important features, such as the ability to reindex or debug queries by viewing the original document.",
    values: {
      source: /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutDescription1.sourceText', {
        defaultMessage: '_source'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("a", {
    href: _documentation.documentationService.getMappingSyntheticSourceFieldLink(),
    target: "_blank",
    rel: "noopener noreferrer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutDescription2",
    defaultMessage: "Learn more about synthetic {source}.",
    values: {
      source: /*#__PURE__*/_react.default.createElement("code", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 17
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutDescription2.sourceText', {
        defaultMessage: '_source'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }))));
  const renderSyntheticWarning = () => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutDescription2",
      defaultMessage: "Synthetic {source} has been set by the selected index mode. Changing this setting will reduce the optimization provided by the index mode. {learnMoreLink}",
      values: {
        source: /*#__PURE__*/_react.default.createElement("code", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 120,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutDescription2.sourceText', {
          defaultMessage: '_source'
        })),
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getMappingSyntheticSourceFieldLink(),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 130,
            columnNumber: 15
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.disabledSourceFieldCallOutDescription2.sourceText', {
          defaultMessage: 'Learn more.'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 9
      }
    }),
    iconType: "warning",
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  });
  const renderFormFields = () => /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "sourceField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "sourceField.includes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, ({
    label,
    helpText,
    value,
    setValue
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    helpText: helpText,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.sourceIncludeField.placeholderLabel', {
      defaultMessage: 'path.to.field.*'
    }),
    selectedOptions: value,
    onChange: newValue => {
      setValue(newValue);
    },
    onCreateOption: searchValue => {
      const newOption = {
        label: searchValue
      };
      setValue([...value, newOption]);
    },
    fullWidth: true,
    "data-test-subj": "includesField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "sourceField.excludes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, ({
    label,
    helpText,
    value,
    setValue
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    helpText: helpText,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    noSuggestions: true,
    placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.sourceExcludeField.placeholderLabel', {
      defaultMessage: 'path.to.field.*'
    }),
    selectedOptions: value,
    onChange: newValue => {
      setValue(newValue);
    },
    onCreateOption: searchValue => {
      const newOption = {
        label: searchValue
      };
      setValue([...value, newOption]);
    },
    fullWidth: true,
    "data-test-subj": "excludesField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 13
    }
  }))));
  return /*#__PURE__*/_react.default.createElement(_shared_imports.FormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.sourceFieldTitle', {
      defaultMessage: '_source field'
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.sourceFieldDescription",
      defaultMessage: "The _source field contains the original JSON document body that was provided at index time. Individual fields can be pruned by defining which ones to include or exclude from the _source field. {docsLink}",
      values: {
        docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _documentation.documentationService.getMappingSourceFieldLink(),
          target: "_blank",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 226,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.sourceFieldDocumentionLink', {
          defaultMessage: 'Learn more.'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 221,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "sourceField.option",
      component: _shared_imports.SuperSelectField,
      componentProps: {
        euiFieldProps: {
          fullWidth: false,
          hasDividers: true,
          'data-test-subj': 'sourceValueField',
          options: sourceValueOptions
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: ['sourceField.option'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 7
    }
  }, formData => {
    const {
      sourceField
    } = formData;
    if ((sourceField === null || sourceField === void 0 ? void 0 : sourceField.option) === undefined) {
      return null;
    }
    return (sourceField === null || sourceField === void 0 ? void 0 : sourceField.option) === _constants.STORED_SOURCE_OPTION ? renderFormFields() : (sourceField === null || sourceField === void 0 ? void 0 : sourceField.option) === _constants.DISABLED_SOURCE_OPTION ? renderDisableWarning() : renderSyntheticWarning();
  }));
};
exports.SourceFieldSection = SourceFieldSection;