"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagedPolicyBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/policy_list/components/managed_policy_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const managedPolicyTooltips = {
  badge: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.templateBadgeType.managedLabel', {
    defaultMessage: 'Managed'
  }),
  badgeTooltip: _i18n.i18n.translate('xpack.indexLifecycleMgmt.policyTable.templateBadgeType.managedDescription', {
    defaultMessage: 'This policy is preconfigured and managed by Elastic; editing or deleting this policy might break Kibana.'
  })
};
const ManagedPolicyBadge = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: managedPolicyTooltips.badgeTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": "managedPolicyBadge",
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, managedPolicyTooltips.badge));
};
exports.ManagedPolicyBadge = ManagedPolicyBadge;